/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.WizardExecutorStep;
import oracle.bpm.ui.wizards.model.WizardSwingWorker;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerActionAdaptor;
import oracle.bpm.ui.wizards.model.WizardTask;
import oracle.bpm.ui.wizards.ui.WizardExecutorPanel;

public class WizardSwingWorkerExecutorAdaptor
extends WizardSwingWorkerActionAdaptor {
    public WizardSwingWorkerExecutorAdaptor(WizardExecutorStep step) {
        super(step);
    }

    protected WizardExecutorStep getExecutorStep() {
        return (WizardExecutorStep)this.getStep();
    }

    @Override
    protected void displayText(String text) {
        WizardExecutorPanel executorPanel = (WizardExecutorPanel)this.getExecutorStep().getStepPanel();
        executorPanel.setTaskText(text);
    }

    protected void executeTask(WizardTask task, WizardSwingWorker worker) throws RuntimeException {
        task.executeTask(worker);
    }

    @Override
    protected void finishActionIn(WizardSwingWorker worker) {
        WizardExecutorStep executorStep = this.getExecutorStep();
        executorStep.displayText(UIMsg.TASKS_COMPLETED.getString());
        executorStep.delay();
    }

    @Override
    protected void startActionIn(WizardSwingWorker worker) {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardSwingWorkerExecutorAdaptor.this.getExecutorStep().startProcessing();
            }
        });
        for (WizardTask task : this.getExecutorStep().getWizardTasks()) {
            this.executeTask(task, worker);
        }
    }

    @Override
    protected void stopActionIn(WizardSwingWorker worker) {
        this.getExecutorStep().stopProcessing();
    }
}

