/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import java.util.List;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardSupport;
import oracle.bpm.ui.wizards.model.WizardSwingWorker;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerExecutorAdaptor;
import oracle.bpm.ui.wizards.model.WizardTask;
import oracle.bpm.ui.wizards.ui.ButtonsStateMemento;
import oracle.bpm.ui.wizards.ui.WizardExecutorPanel;

public abstract class WizardExecutorStep
extends WizardStep<Wizard> {
    private ButtonsStateMemento buttonsMemento;

    public WizardExecutorStep(Wizard owner) {
        super(owner);
    }

    public WizardExecutorStep(Wizard owner, boolean allowsBackwardMovement) {
        super(owner, allowsBackwardMovement);
    }

    public abstract String getDescriptionText();

    @Override
    public boolean doProcess() {
        new WizardSwingWorker(new WizardSwingWorkerExecutorAdaptor(this)).start();
        return true;
    }

    @Override
    public final void undoProcess() {
    }

    public List<WizardTask> getWizardTasks() {
        return ((Wizard)this.getWizard()).processingTasks();
    }

    @Override
    public void showIn(WizardSupport support) {
        this.clearPanel();
        super.showIn(support);
    }

    protected void clearPanel() {
        WizardExecutorPanel panel = (WizardExecutorPanel)this.getStepPanel();
        if (panel != null) {
            panel.clearWheel();
        }
        this.displayText("");
    }

    protected void delay() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void displayText(String aText) {
        WizardExecutorPanel panel = (WizardExecutorPanel)this.getStepPanel();
        if (panel != null) {
            panel.setTaskText(aText);
        }
    }

    protected void startProcessing() {
        this.buttonsMemento = ((WizardExecutorPanel)this.getStepPanel()).disableButtons();
        this.getStepPanel().setCursor(Cursor.get(Cursor.CursorType.WAIT_CURSOR));
        ((WizardExecutorPanel)this.getStepPanel()).startWheel();
    }

    protected void stopProcessing() {
        ((WizardExecutorPanel)this.getStepPanel()).setButtonsState(this.buttonsMemento);
        this.getStepPanel().setCursor(Cursor.get(Cursor.CursorType.DEFAULT_CURSOR));
        ((WizardExecutorPanel)this.getStepPanel()).stopWheel();
    }
}

