/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.wizards.model;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardSwingWorker;
import oracle.bpm.ui.wizards.model.WizardTask;

public class CompositeWizardTask
extends WizardTask {
    protected int currentTask_d = 0;
    protected List<WizardTask> tasks_d = new ArrayList<WizardTask>();

    public CompositeWizardTask(Wizard wizard) {
        super(wizard);
    }

    public WizardTask getCurrentTask() {
        return this.getTasks().get(this.currentTask_d);
    }

    @Override
    public String getDescription() {
        return this.getCurrentTask().getDescription();
    }

    public void setTasks(List<WizardTask> tasks) {
        this.tasks_d = tasks;
    }

    public List<WizardTask> getTasks() {
        return this.tasks_d;
    }

    public void add(WizardTask task) {
        this.getTasks().add(task);
    }

    @Override
    public boolean execute(WizardSwingWorker worker) {
        boolean answer = false;
        for (WizardTask task : this.getTasks()) {
            answer = task.execute(worker);
            if (answer) continue;
            return answer;
        }
        return true;
    }

    @Override
    protected boolean execute(Object object, WizardSwingWorker worker) {
        boolean answer = false;
        for (WizardTask task : this.getTasks()) {
            answer = task.execute(object, worker);
            if (answer) continue;
            return answer;
        }
        return true;
    }

    protected void nextTask() {
        if (this.currentTask_d < this.getTasks().size()) {
            ++this.currentTask_d;
        }
    }
}

