/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.utils;

import java.util.List;
import java.util.Locale;
import oracle.bpm.geom.Dimension;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Locales;

public class LocaleUtils {
    private static ComboBox allLocalesCombo;
    private static final LabelProvider LABEL_PROVIDER;

    private LocaleUtils() {
    }

    public static String getLanguageString(Locale locale) {
        return locale.getDisplayLanguage().equals("") ? UIMsg.DEFAULT_LOCALE.getString() : locale.getDisplayLanguage();
    }

    public static ComboBox createLocalesCombo(UiContainer parent, Locale[] locales) {
        return LocaleUtils.createLocalesCombo(parent, ArrayUtils.asList(locales));
    }

    public static ComboBox createLocalesCombo(UiContainer parent, List locales) {
        ComboBox comboBox = UiFactory.createMutableComboBox(parent, locales);
        comboBox.setToolTipMsg(CoreMsg.LANGUAGE);
        comboBox.setLabelProvider(LABEL_PROVIDER);
        comboBox.setMaximumSize(LocaleUtils.getLocalesDimension(parent));
        comboBox.setMinimumSize(LocaleUtils.getLocalesDimension(parent));
        return comboBox;
    }

    private static Dimension getLocalesDimension(UiContainer parent) {
        if (allLocalesCombo == null) {
            allLocalesCombo = UiFactory.createComboBox(parent, Locales.getSupportedLanguages());
            allLocalesCombo.setLabelProvider(LABEL_PROVIDER);
            allLocalesCombo.setMaximumSize(allLocalesCombo.getPreferredSize());
        }
        return allLocalesCombo.getMaximumSize();
    }

    static {
        LABEL_PROVIDER = new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                String displayLanguage = ((Locale)element).getDisplayLanguage();
                return displayLanguage.equals("") ? UIMsg.DEFAULT_LOCALE.getString() : displayLanguage;
            }
        };
    }
}

