/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.utils;

import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.util.ArrayUtils;

public class FontUtils {
    public static int UNDERLINE_NONE = 0;
    public static int UNDERLINE_STRIKETHROUGH = 1;
    private static String[] availableFontFamilyNames;
    private static List availableFontsList;
    private static String[] minimalFontFamilyNames;
    private static List minimalFontsList;
    public static final String[] FONT_SIZES_ARRAY;
    private static final String[] fontHTMLSizesArray;
    private static List fontSizesList;
    private static List fontHTMLSizesList;
    private static final String[] fontSizes;

    private FontUtils() {
    }

    public static String[] getAvailableFontFamilyNames() {
        FontUtils.init();
        return availableFontFamilyNames;
    }

    public static List getFontFamilyList() {
        FontUtils.init();
        return availableFontsList;
    }

    public static ComboBox createDefaultFamily(UiContainer parent) {
        FontUtils.init();
        return FontUtils.setupForFamily(UiFactory.createComboBox(parent, availableFontsList));
    }

    public static FontPreviewPanel createFontPreviewPanel(UiContainer parent) {
        return new FontPreviewPanel(parent);
    }

    public static FontPreviewPanel createFontPreviewPanel(UiContainer parent, Font font, Color backgroundColor, Color foregroundColor) {
        return new FontPreviewPanel(parent, font, backgroundColor, foregroundColor);
    }

    public static ComboBox createHTMLSizesCombo(UiContainer parent) {
        FontUtils.init();
        ComboBox comboBox = UiFactory.createComboBox(parent, fontHTMLSizesList);
        comboBox.setToolTipMsg(UIMsg.FONT_SIZE);
        comboBox.setPrototypeDisplayValue("000");
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        return comboBox;
    }

    public static ComboBox createMinimalFamily(UiContainer parent) {
        FontUtils.init();
        return FontUtils.setupForFamily(UiFactory.createComboBox(parent, minimalFontsList));
    }

    public static ComboBox createSizesCombo(UiContainer parent) {
        FontUtils.init();
        ComboBox comboBox = UiFactory.createComboBox(parent, fontSizesList);
        comboBox.setToolTipMsg(UIMsg.FONT_SIZE);
        comboBox.setPrototypeDisplayValue("000");
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        return comboBox;
    }

    public static String[] getDefaultFontSizes() {
        return fontSizes;
    }

    private static void init() {
        if (availableFontFamilyNames == null) {
            availableFontFamilyNames = Ui.getAvailableFontFamilyNames();
            availableFontsList = ArrayUtils.asList(availableFontFamilyNames);
            minimalFontFamilyNames = new String[]{"Serif", "Monospaced", "SansSerif"};
            minimalFontsList = ArrayUtils.asList(minimalFontFamilyNames);
            fontSizesList = ArrayUtils.asList(FONT_SIZES_ARRAY);
            fontHTMLSizesList = ArrayUtils.asList(fontHTMLSizesArray);
        }
    }

    private static ComboBox setupForFamily(ComboBox comboBox) {
        comboBox.setToolTipMsg(UIMsg.FONTS);
        comboBox.setMaximumSize(comboBox.getPreferredSize());
        return comboBox;
    }

    static {
        FONT_SIZES_ARRAY = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        fontHTMLSizesArray = new String[]{"8", "10", "12", "14", "18", "24", "36"};
        fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    }

    public static class FontPreviewPanel
    extends Panel {
        private Label previewLabel;

        public FontPreviewPanel(UiContainer parent) {
            super(parent, UIMsg.TO_MSG(""));
            this.setLayout(new BorderLayout());
            this.initGui();
        }

        public FontPreviewPanel(UiContainer parent, Font font) {
            this(parent);
            this.updatePreview(font);
        }

        public FontPreviewPanel(UiContainer parent, Font font, Color backgroundColor, Color foregroundColor) {
            this(parent, font);
            this.setBackgroundColor(backgroundColor);
            this.setForegroundColor(foregroundColor);
        }

        public void setBackgroundColor(Color color) {
            this.previewLabel.setBackground(color);
        }

        public void setForegroundColor(Color color) {
            this.previewLabel.setForeground(color);
        }

        public void setTextToPreview(String text) {
            this.previewLabel.setText(text);
        }

        public void updatePreview(Color backgroundColor, Color foregroundColor) {
            this.setBackgroundColor(backgroundColor);
            this.setForegroundColor(foregroundColor);
            this.repaint();
        }

        public void updatePreview(Font font) {
            this.previewLabel.setFont(font);
            this.previewLabel.repaint();
        }

        private void initGui() {
            this.previewLabel = Label.create((UiContainer)this, Msg.QUOTE("The quick brown fox jumps over the lazy dog."));
            this.previewLabel.setHorizontalAlignment(0);
            this.setBackgroundColor(Color.WHITE);
            this.setForegroundColor(Color.BLACK);
            this.previewLabel.setOpaque(true);
            this.add(this.previewLabel, "Center");
        }
    }
}

