/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.utils;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.CompositeButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.ColorUtils;

public class ColorChooserButton
extends CompositeButton {
    private BaseAction applyCurrentColorAction;
    private ColorUtils.FuegoPaintedButton applyCurrentColorButton;
    private BaseAction chooseNewColorAction;
    private Color currentColor;
    static final long serialVersionUID = 1643998083422860789L;
    static final long serialCheck = -5958966262079576416L;

    public ColorChooserButton(final UiContainer parent, final Msg msg) {
        super(parent);
        this.applyCurrentColorAction = new BaseAction(msg){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorChooserButton.this.currentColor == null) {
                    Color chosenColor = ColorChooser.showDialog(parent, msg, ColorChooserButton.this.currentColor);
                    if (chosenColor == null) {
                        return;
                    }
                    ColorChooserButton.this.currentColor = chosenColor;
                }
                ColorChooserButton.this.applyColor(e);
            }
        };
        this.applyCurrentColorButton = new ColorUtils.FuegoPaintedButton((UiContainer)this, this.applyCurrentColorAction);
        this.chooseNewColorAction = new BaseAction(msg){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color chosenColor = ColorChooser.showDialog(parent, msg, ColorChooserButton.this.currentColor);
                if (chosenColor == null) {
                    return;
                }
                ColorChooserButton.this.currentColor = chosenColor;
                ColorChooserButton.this.applyColor(e);
            }
        };
        this.setFirst(this.applyCurrentColorButton);
        this.setDropDownAction(this.chooseNewColorAction);
    }

    public static ColorChooserButton createBackgroundButton(UiContainer parent) {
        ColorChooserButton result = new ColorChooserButton(parent, UIMsg.BGROUND);
        return result;
    }

    public static ColorChooserButton createForegroundButton(UiContainer parent) {
        ColorChooserButton result = new ColorChooserButton(parent, UIMsg.FGROUND);
        return result;
    }

    public BaseAction getChooseNewColorAction() {
        return this.chooseNewColorAction;
    }

    public void setColor(Color currentColor) {
        this.currentColor = currentColor;
        this.applyCurrentColorButton.setColor(currentColor);
    }

    public Color getColor() {
        return this.currentColor;
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        this.applyCurrentColorButton.setFocusable(focusable);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
    }

    private ActionListener[] getActionListeners() {
        return new ActionListener[0];
    }

    private void applyColor(ActionEvent e) {
        this.applyCurrentColorButton.setColor(this.currentColor);
        ActionListener[] actionListeners = this.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            ActionListener actionListener = actionListeners[i];
            actionListener.actionPerformed(e);
        }
    }
}

