/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import java.util.List;

public final class TreePath {
    private transient Object lastPathComponent;
    private TreePath parentPath;

    private TreePath(Object singlePath) {
        if (singlePath == null || singlePath instanceof Object[]) {
            throw new IllegalArgumentException("path in TreePath must be non null and single");
        }
        this.setLastPathComponent(singlePath);
        this.parentPath = null;
    }

    private TreePath(Object[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.setLastPathComponent(path[path.length - 1]);
        if (path.length > 1) {
            this.parentPath = new TreePath(path, path.length - 1);
        }
    }

    private TreePath(TreePath parent, Object lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = parent;
        this.setLastPathComponent(lastElement);
    }

    private TreePath(Object[] path, int length) {
        this.setLastPathComponent(path[length - 1]);
        if (length > 1) {
            this.parentPath = new TreePath(path, length - 1);
        }
    }

    public static TreePath create(Object[] path) {
        return new TreePath(path);
    }

    public static TreePath create(List<?> path) {
        return new TreePath(path.toArray());
    }

    public static TreePath createSinglePath(Object singlePath) {
        return new TreePath(singlePath);
    }

    public boolean isDescendant(TreePath treePath) {
        boolean result;
        boolean bl = result = treePath == this;
        if (!result && treePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = treePath.getPathCount();
            if (oPathLength < pathLength) {
                result = false;
            } else {
                while (oPathLength-- > pathLength) {
                    treePath = treePath.getParentPath();
                }
                result = this.equals(treePath);
            }
        }
        return result;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TreePath path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o == this;
        if (!result && o != null && o instanceof TreePath) {
            TreePath that = (TreePath)o;
            result = this.getPathCount() == that.getPathCount();
            TreePath path = this;
            while (result && path != null) {
                result = path.lastPathComponent.equals(that.lastPathComponent);
                path = path.parentPath;
                that = that.parentPath;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public TreePath pathByAddingChild(Object child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, child);
    }

    public String toString() {
        StringBuffer tempSpot = new StringBuffer("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public Object getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        TreePath path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TreePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    private void setLastPathComponent(Object lastPathComponent) {
        this.lastPathComponent = lastPathComponent;
    }
}

