/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.adapter.DefaultAdaptable;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Stack;
import oracle.bpm.collections.iterator.SingleValueIterator;
import oracle.bpm.draw.Color;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.tree.DefaultTreeNodeFactory;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNodeFactory;
import oracle.bpm.ui.tree.TreeNodeVisitor;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.utils.FontUtils;
import org.jetbrains.annotations.Nullable;

public class TreeNode
implements Iterable<TreeNode>,
Adaptable {
    protected Image icon;
    private ActionGroupFactory actionFactory;
    private boolean allowsChildren = true;
    private List<TreeNode> children = new ArrayList<TreeNode>();
    private Map<String, BaseAction> commonActionsMap;
    private PopupMenu defaultPopup;
    private boolean loaded;
    private boolean loading;
    private Msg msg;
    private TreeNode parent;
    private Tree tree;
    private boolean updatingBatch;
    private Object userObject;
    private static Map<Class, TreeNodeFactory> factories;
    private static final Map<Class, TreeNodeFactory> resolvedFactories;

    protected TreeNode() {
    }

    protected TreeNode(Object object) {
        this();
        this.userObject = object;
    }

    public static TreeNode create(Object object) {
        return new TreeNode(object);
    }

    public static TreeNode create() {
        return new TreeNode();
    }

    public static TreeNode createDynamic(Object context) {
        return TreeNode.createDynamic(DefaultAdaptable.create(context), context.getClass());
    }

    public void reloadIcon() {
    }

    public boolean isUpdatingBatch() {
        return this.updatingBatch;
    }

    public void setUpdatingBatch(boolean updatingBatch) {
        this.updatingBatch = updatingBatch;
        if (!updatingBatch) {
            this.nodeChanged();
        }
    }

    @Nullable
    public String getToolTipText() {
        return null;
    }

    public void add(TreeNode newChild) {
        if (this.isNodeChild(newChild)) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    @Deprecated
    public TreeNode addDynamic(TreeNode node) {
        throw new IllegalArgumentException("Do not call addDynamic with a node: " + node);
    }

    public List<TreeNode> addDynamic(Iterable<?> list) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (Object data : list) {
            result.add(this.addDynamic(data, null));
        }
        return result;
    }

    public TreeNode addDynamic(Object data) {
        return this.addDynamic(data, null);
    }

    public TreeNode addDynamic(Object data, Comparator comparator) {
        TreeNode treeNode;
        assert (!(data instanceof TreeNode)) : "Do not use addDynamic for regular nodes: " + data;
        if (data == null) {
            throw new IllegalArgumentException("Cannot add 'null' node");
        }
        try {
            treeNode = TreeNode.createDynamic(data);
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace();
            treeNode = new ErrorTreeNode(data);
            treeNode.setMsg(UIMsg.ERROR_MSG(data.toString()));
        }
        if (treeNode != null) {
            if (this.getTree() == null) {
                if (comparator != null) {
                    this.insert(treeNode, comparator);
                } else {
                    this.add(treeNode);
                }
            } else if (comparator != null) {
                this.getTree().insertSortedNode(treeNode, this, comparator, true);
            } else {
                this.getTree().insertNodeInto(treeNode, this, this.getChildCount(), true);
            }
        }
        return treeNode;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public TreeNode getRoot() {
        return this.isRoot() ? this : this.getParent().getRoot();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        return anotherNode != null && (this == anotherNode || this.hasParent() && this.getParent().isNodeAncestor(anotherNode));
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void collapse() {
        this.getTree().collapsePath(this.getTreePath());
    }

    public ActionGroupFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionGroupFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public ActionGroup createActions() {
        ActionGroup result = null;
        if (this.actionFactory != null) {
            result = this.actionFactory.create(this);
        }
        return result;
    }

    public boolean delete() {
        return false;
    }

    public void doubleClick(MouseEvent e) {
        if (this.isExpanded()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void expand() {
        Tree tree = this.getTree();
        if (tree != null && !this.isAncestorLoading()) {
            tree.expandPath(this.getTreePath());
        }
    }

    public boolean isExpanded() {
        return this.getTree().isExpanded(this.getTreePath());
    }

    public final TreeNode findPath(String[] path, Matcher matcher) {
        return !matcher.match(path[0], this) ? null : this.findSubPath(path, matcher, 1);
    }

    public TreeNode findTreeNodeByUserObject(Object object) {
        Iterable<TreeNode> nodes = this.preorder();
        for (TreeNode treeNode : nodes) {
            if (treeNode.getUserObject() != object) continue;
            return treeNode;
        }
        return null;
    }

    public TreeNode findChildByUserObject(Object userObject) {
        List<TreeNode> children = this.getChildren();
        for (TreeNode child : children) {
            if (child.getUserObject() != userObject) continue;
            return child;
        }
        return null;
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public final void unload() {
        if (this.isLoaded()) {
            this.removeAllChildren();
        }
        this.loaded = false;
    }

    public synchronized int getChildCount() {
        return this.getChildren().size();
    }

    public final List<TreeNode> getChildren() {
        this.ensureLoaded();
        return this.children;
    }

    public void loadTree() {
        this.ensureLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLoaded() {
        if (!this.isLoaded()) {
            this.loading = true;
            this.loaded = true;
            try {
                this.onLoading();
            }
            finally {
                assert (this.loaded) : "Should be loaded";
                assert (this.loading) : "Should be loading";
                this.loading = false;
            }
        }
    }

    public int getColorModifiers() {
        return Color.BLACK.getRGB();
    }

    public Map<String, BaseAction> getCommonActionsMap() {
        if (this.commonActionsMap == null) {
            this.commonActionsMap = new HashMap<String, BaseAction>();
            this.addCommonActions();
        }
        return this.commonActionsMap;
    }

    public FontStyle getFontModifiers() {
        return FontStyle.PLAIN;
    }

    public Image getIcon() {
        return this.icon != null ? this.icon : Image.create(this.msg);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public String getText() {
        return this.getMsg() == null ? this.toString() : this.getMsg().getString();
    }

    public PopupMenu getPopup() {
        ActionGroup actions = this.createActions();
        if (actions != null) {
            actions.setSelection(this.getSelection());
            this.defaultPopup = PopupMenu.create(this.getTree().getParent(), actions);
        }
        return this.defaultPopup;
    }

    public oracle.bpm.ui.selection.Selection getSelection() {
        return DefaultSelection.createSingle(this.getUserObject());
    }

    public String getTemplate() {
        return "";
    }

    public Tree getTree() {
        TreeNode parent;
        if (this.tree == null && (parent = this.getParent()) != null) {
            this.tree = parent.getTree();
        }
        return this.tree;
    }

    public TreePath getTreePath() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        this.addParentNodes(nodes, this);
        nodes.add(this);
        return TreePath.create(nodes);
    }

    public int getUnderLineModifiers() {
        return FontUtils.UNDERLINE_NONE;
    }

    public void remove(TreeNode child) {
        TreeNode.assertArgument(child != null, "argument is null");
        TreeNode.assertArgument(this.isNodeChild(child), "argument is not a child");
        this.remove(this.getIndex(child));
    }

    public int getIndex(TreeNode child) {
        TreeNode.assertArgument(child != null, "argument is null");
        return !this.isNodeChild(child) ? -1 : this.getChildren().indexOf(child);
    }

    public final void remove(int childIndex) {
        TreeNode child = this.getChildAt(childIndex);
        child.removeListeners();
        if (child.isLoaded()) {
            child.unload();
        }
        this.getChildren().remove(childIndex);
        child.setParent(null);
    }

    public boolean isNodeChild(TreeNode node) {
        return node != null && this.getChildCount() != 0 && node.getParent() == this;
    }

    public void insert(TreeNode newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        newChild.changeParent(this);
        this.getChildren().add(childIndex, newChild);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void nodeChanged() {
        Tree tree = this.getTree();
        if (tree != null && !tree.isDisposed()) {
            tree.fireNodeChanged(this);
        }
    }

    public void nodeStructureChanged() {
        Tree tree = this.getTree();
        if (tree != null) {
            tree.fireNodeStructureChanged(this);
        }
    }

    public void onMouseSelection(MouseEvent e) {
    }

    public void onSelection(TreeSelectionEvent event) {
    }

    public void refreshMemberVisibility(int mask) {
        if (this.loaded) {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                this.getChildAt(i).refreshMemberVisibility(mask);
            }
        }
    }

    public void reload() {
        Tree tree = this.getTree();
        if (!this.loading) {
            if (tree != null) {
                tree.fireNodeStructureChanged(this);
            } else {
                this.loaded = false;
                this.children.clear();
                this.loadTree();
            }
        }
    }

    public void reload(Object object) {
        this.userObject = object;
        this.reload();
    }

    public void reloadParent() {
        Tree tree;
        if (this.hasParent() && (tree = this.getTree()) != null) {
            tree.reload();
        }
    }

    public void removeFromParent() {
        TreeNode treeNode = this;
        if (treeNode.getParent() != null) {
            treeNode.getTree().removeNodeFromParent(treeNode);
        }
    }

    public void select() {
        TreePath treePath = this.getTreePath();
        Tree tree = this.getTree();
        if (tree != null && !tree.isDisposed()) {
            TreePath parentPath = treePath.getParentPath();
            tree.expandPath(parentPath);
            tree.setSelectionPath(treePath);
            tree.scrollPathToVisible(treePath);
        }
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        if (msg.hasImage() && this.icon == null) {
            this.icon = Image.create(msg);
        }
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Iterator<TreeNode> iterator() {
        return this.getChildren().iterator();
    }

    public TreeNode getChildAt(int i) {
        return this.getChildren().get(i);
    }

    public void setParent(TreeNode newParent) {
        this.parent = newParent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void removeAllChildren() {
        for (int i = this.getChildren().size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getNextSibling() {
        TreeNode result;
        TreeNode myParent = this.getParent();
        TreeNode treeNode = result = myParent == null ? null : myParent.getChildAfter(this);
        if (result != null && !this.isNodeSibling(result)) {
            throw new Error("child of parent is not a sibling");
        }
        return result;
    }

    public TreeNode getPreviousLeaf() {
        TreeNode result = null;
        TreeNode myParent = this.getParent();
        if (myParent != null) {
            TreeNode previousSibling = this.getPreviousSibling();
            result = previousSibling == null ? myParent.getPreviousLeaf() : previousSibling.getLastLeaf();
        }
        return result;
    }

    public TreeNode getPreviousSibling() {
        TreeNode result;
        TreeNode myParent = this.getParent();
        TreeNode treeNode = result = myParent == null ? null : myParent.getChildBefore(this);
        if (result != null && !this.isNodeSibling(result)) {
            throw new Error("child of parent is not a sibling");
        }
        return result;
    }

    public TreeNode getChildBefore(TreeNode child) {
        TreeNode.assertArgument(child != null, "argument is null");
        int index = this.getIndex(child);
        TreeNode.assertArgument(index != -1, "argument is not a child");
        return index <= 0 ? null : this.getChildAt(index - 1);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode getLastLeaf() {
        return this.isLeaf() ? this : this.getLastChild().getLastLeaf();
    }

    public TreeNode getChildAfter(TreeNode child) {
        TreeNode.assertArgument(child != null, "argument is null");
        int index = this.getIndex(child);
        TreeNode.assertArgument(index != -1, "argument is not a child");
        return index < this.getChildCount() - 1 ? this.getChildAt(index + 1) : null;
    }

    public boolean isNodeSibling(TreeNode anotherNode) {
        return anotherNode != null && (anotherNode == this || this.haveSameParent(anotherNode));
    }

    public boolean haveSameParent(TreeNode anotherNode) {
        boolean sameParent;
        boolean bl = sameParent = this.hasParent() && this.getParent() == anotherNode.getParent();
        if (sameParent && !this.getParent().isNodeChild(anotherNode)) {
            throw new Error("sibling has different parent");
        }
        return sameParent;
    }

    public void insert(TreeNode treeNode, Comparator<TreeNode> comparator) {
        int indexToInsert = 0;
        for (TreeNode node : this) {
            if (comparator.compare(treeNode, node) < 0) break;
            ++indexToInsert;
        }
        int indexToInsert1 = indexToInsert;
        TreeNode thisTreeNode = this;
        if (indexToInsert1 >= thisTreeNode.getChildCount()) {
            thisTreeNode.add(treeNode);
        } else {
            thisTreeNode.insert(treeNode, indexToInsert1);
        }
    }

    public void setAllowsChildren(boolean allowsChildren) {
        if (allowsChildren != this.allowsChildren) {
            this.allowsChildren = allowsChildren;
            if (!allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public Iterable<TreeNode> postorder() {
        return new PostorderIterator(this);
    }

    public Iterable<TreeNode> depthFirst() {
        return new PostorderIterator(this);
    }

    public Iterable<TreeNode> preorder() {
        return new PreorderIterator(this);
    }

    public void setSelected(Selection selection) {
        throw new UnsupportedOperationException();
    }

    public boolean shouldOpenOnDoubleClick() {
        return true;
    }

    public String toString() {
        return this.userObject == null ? super.toString() : this.userObject.toString();
    }

    public final void deletePressed() {
        this.delete();
    }

    public void accept(TreeNodeVisitor visitor) {
        if (visitor.visit(this)) {
            for (TreeNode treeNode : this.getChildren()) {
                treeNode.accept(visitor);
            }
        }
    }

    public int getLevel() {
        if (this.isRoot()) {
            return 0;
        }
        return 1 + this.getParent().getLevel();
    }

    @Override
    public <T> T as(Class<T> targetType) {
        T result = null;
        if (targetType.isAssignableFrom(this.getClass())) {
            result = targetType.cast(this);
        } else {
            Object userObject = this.getUserObject();
            if (userObject != null && targetType.isAssignableFrom(userObject.getClass())) {
                result = targetType.cast(userObject);
            } else if (userObject instanceof Adaptable) {
                result = ((Adaptable)userObject).as(targetType);
            }
        }
        return result;
    }

    protected void addCommonActions() {
        assert (this.commonActionsMap != null) : "Common Action Map is not created";
    }

    protected void onLoading() {
    }

    protected void removeListeners() {
    }

    private static Map<Class, TreeNodeFactory> loadFactories() {
        ExtensionService service = Platform.getExtensionService();
        HashMap<Class, TreeNodeFactory> map = new HashMap<Class, TreeNodeFactory>();
        List<Extension<TreeNodeMetadata>> all = service.getExtensionsByPoint(TreeNodeMetadata.class);
        for (Extension<TreeNodeMetadata> extension : all) {
            try {
                Class target = extension.getMetadata().objectType();
                Class type = extension.instanceType();
                TreeNodeFactory factory = TreeNode.class.isAssignableFrom(type) ? new DefaultTreeNodeFactory(type) : extension.instantiateAs(TreeNodeFactory.class);
                map.put(target, factory);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeNode createDynamic(Adaptable context, Class cl) {
        TreeNodeFactory factory;
        TreeNode result = null;
        Map<Class, TreeNodeFactory> map = resolvedFactories;
        synchronized (map) {
            factory = resolvedFactories.get(cl);
            if (factory == null) {
                factory = TreeNode.resolveFactory(cl);
                resolvedFactories.put(cl, factory);
            }
        }
        if (factory != null && (result = factory.create(context)) == null) {
            throw new IllegalStateException("Factory '" + factory + "' didn't create a node for " + context);
        }
        return result;
    }

    private static TreeNodeFactory resolveFactory(Class cl) {
        TreeNodeFactory factory;
        if (factories == null) {
            factories = TreeNode.loadFactories();
        }
        if ((factory = factories.get(cl)) == null) {
            Class superClass;
            Class<?> iface;
            Class<?>[] arr$ = cl.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (factory = TreeNode.resolveFactory(iface = arr$[i$])) == null; ++i$) {
            }
            if (factory == null && (superClass = cl.getSuperclass()) != null) {
                factory = TreeNode.resolveFactory(superClass);
            }
        }
        return factory;
    }

    private static void assertArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private boolean isAncestorLoading() {
        for (TreeNode parent = this; parent != null; parent = parent.getParent()) {
            if (!parent.isLoading()) continue;
            return true;
        }
        return false;
    }

    private void changeParent(TreeNode newParent) {
        TreeNode oldParent = this.getParent();
        if (oldParent != null) {
            oldParent.remove(this);
        }
        this.setParent(newParent);
    }

    private TreeNode[] getPathToRoot(TreeNode node, int depth) {
        TreeNode[] result = null;
        if (node != null) {
            result = this.getPathToRoot(node.getParent(), ++depth);
            result[result.length - depth] = node;
        } else if (depth != 0) {
            result = new TreeNode[depth];
        }
        return result;
    }

    private void addParentNodes(List<TreeNode> list, TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent != null) {
            list.add(0, parent);
            this.addParentNodes(list, parent);
        }
    }

    private TreeNode findSubPath(String[] path, Matcher matcher, int index) {
        TreeNode result = null;
        if (path.length - index <= 0) {
            result = this;
        } else {
            for (TreeNode child : this) {
                if (!matcher.match(path[index], child)) continue;
                result = child.findSubPath(path, matcher, index + 1);
                break;
            }
        }
        return result;
    }

    static {
        resolvedFactories = new HashMap<Class, TreeNodeFactory>();
    }

    static final class PreorderIterator
    implements Iterator<TreeNode>,
    Iterable<TreeNode> {
        private Stack<Iterator<TreeNode>> stack;

        public PreorderIterator(TreeNode rootNode) {
            SingleValueIterator<TreeNode> root = SingleValueIterator.create(rootNode);
            this.stack = Stack.create(root);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public TreeNode next() {
            Iterator<TreeNode> children;
            Iterator<TreeNode> iterator = this.stack.peek();
            TreeNode node = iterator.next();
            if (!iterator.hasNext()) {
                this.stack.pop();
            }
            if ((children = node.iterator()).hasNext()) {
                this.stack.push(children);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TreeNode> iterator() {
            return this;
        }
    }

    static final class PostorderIterator
    implements Iterator<TreeNode>,
    Iterable<TreeNode> {
        private Iterator<TreeNode> children;
        private TreeNode root;
        private Iterator<TreeNode> subtree;

        public PostorderIterator(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.iterator();
            this.subtree = CollectionUtils.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public TreeNode next() {
            TreeNode result;
            if (this.subtree.hasNext()) {
                result = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                result = this.subtree.next();
            } else {
                result = this.root;
                this.root = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TreeNode> iterator() {
            return this;
        }
    }

    static class ErrorTreeNode
    extends TreeNode {
        public ErrorTreeNode(Object data) {
            super(data);
        }
    }

    public static interface Matcher {
        public boolean match(String var1, TreeNode var2);
    }

    public static enum Selection {
        NONE,
        ALL,
        PARTIAL;

    }
}

