/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class TreeBasePanel
extends Panel {
    private BaseAction addAction;
    private BaseAction removeAction;
    private Style style;
    private Tree tree;

    public TreeBasePanel(UiContainer parent, Msg title) {
        this(parent, title, Style.TOOLBAR);
    }

    public TreeBasePanel(UiContainer parent, Msg title, Style style) {
        super(parent, title);
        this.style = style;
        this.init(null);
    }

    public void setRoot(TreeNode root) {
        this.tree.setRoot(root);
    }

    public TreeNode getRoot() {
        return this.tree.getRoot();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
        this.removeAction.setEnabled(enabled && this.isDeletableSelection());
        this.addAction.setEnabled(enabled && this.isAddableSelection());
    }

    public void addTreeSelectionListener(TreeSelectionListener selectionListener) {
        this.tree.addTreeSelectionListener(selectionListener);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.tree.addTreeModelListener(treeModelListener);
    }

    public TreeNode[] getSelectedNode() {
        return this.tree.getSelectedTreeNodes();
    }

    public TreeNode getSelectedTreeNode() {
        return this.tree.getSelectedTreeNode();
    }

    protected abstract void addAction(@NotNull TreeNode var1);

    protected void selectionChanged() {
        this.addAction.setEnabled(this.isAddableSelection());
        this.removeAction.setEnabled(this.isDeletableSelection());
    }

    protected void deleteAction(@NotNull TreeNode selectedNode) {
        TreeNode parentNode = selectedNode.getParent();
        int index = parentNode.getIndex(selectedNode) - 1;
        selectedNode.removeFromParent();
        if (index > -1) {
            parentNode.getChildAt(index).select();
        } else {
            parentNode.select();
        }
    }

    protected boolean isAddableSelection() {
        return this.tree.getSelectedTreeNode() != null;
    }

    protected boolean isEditableSelection() {
        return this.isDeletableSelection();
    }

    private void init(Msg description) {
        this.setLayout(new BorderLayout(5, 5));
        if (description != null) {
            this.add(new LabelMultiline(this, description), "North");
        }
        this.tree = this.buildTree(this);
        UiComponent actionsPanel = this.buildActionsPanel(this);
        this.add(this.tree, "Center");
        this.add(actionsPanel, "East");
    }

    private Tree buildTree(UiContainer parent) {
        Tree tree = new Tree(parent);
        tree.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeBasePanel.this.selectionChanged();
            }
        });
        return tree;
    }

    private UiComponent buildActionsPanel(UiContainer parent) {
        ArrayList<BaseAction> actionsList = new ArrayList<BaseAction>();
        this.addAction = new BaseAction(UIMsg.ADD){

            @Override
            public void run() {
                TreeBasePanel.this.addAction(TreeBasePanel.this.tree.getSelectedTreeNode());
            }
        };
        this.removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                TreeBasePanel.this.deleteAction(TreeBasePanel.this.tree.getSelectedTreeNode());
            }
        };
        this.addAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        actionsList.add(this.addAction);
        actionsList.add(this.removeAction);
        return this.style.equals((Object)Style.BUTTON) ? this.buildButtonPanel(parent, actionsList) : this.buildToolBarPanel(parent, actionsList);
    }

    private UiComponent buildButtonPanel(UiContainer parent, List<BaseAction> actions) {
        Panel panel = new Panel(parent);
        String colSpecs = "pref:grow, 5dlu";
        String rowSpecs = "";
        FormLayout layout = new FormLayout("pref:grow, 5dlu", "");
        PanelBuilder builder = layout.createBuilder(panel);
        CellConstraints cc = layout.createCellConstraints();
        for (BaseAction action : actions) {
            if (action != null) {
                layout.appendRow("pref");
                builder.add((UiComponent)new Button((UiContainer)panel, action), cc.xy(1, layout.getRowCount()));
                layout.appendRow("5dlu");
                continue;
            }
            layout.appendRow("10dlu");
        }
        return panel;
    }

    private UiComponent buildToolBarPanel(UiContainer parent, List<BaseAction> actions) {
        ToolBar toolBar = new ToolBar(parent, ToolBar.VERTICAL);
        for (BaseAction action : actions) {
            if (action != null) {
                toolBar.add(action);
                continue;
            }
            toolBar.addSeparator();
        }
        return toolBar;
    }

    private boolean isDeletableSelection() {
        TreeNode selectedNode = this.tree.getSelectedTreeNode();
        return selectedNode != null && selectedNode != this.tree.getRoot();
    }

    public static enum Style {
        BUTTON,
        TOOLBAR;

    }
}

