/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeExpansionEvent;
import oracle.bpm.ui.event.TreeExpansionListener;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.event.TreeWillExpandListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.TreePeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.tree.ExpandVetoException;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.utils.FontUtils;

public class Tree
extends UiContainer {
    private boolean cleaned = false;
    private boolean initialized;
    private boolean popupEnabled = true;
    private boolean scrollable = true;

    public Tree(UiContainer parent) {
        super(parent);
    }

    public Tree(UiContainer parent, boolean scrollable) {
        super(parent);
        this.scrollable = scrollable;
    }

    public Tree(UiContainer parent, Object[] value) {
        this(parent);
        TreeNode root = TreeNode.create("root");
        for (Object aValue : value) {
            root.add(TreeNode.create(aValue));
        }
        this.setRoot(root);
    }

    public Tree(UiContainer parent, TreeNode root) {
        this(parent);
        if (root != null) {
            root.setTree(this);
        }
        this.setRoot(root);
    }

    public static void allNodesChanged(Tree tree) {
        assert (UiUtilities.isEventDispatchThread());
        TreeNode root = tree.getRoot();
        if (root != null) {
            for (TreeNode treeNode : root) {
                treeNode.nodeChanged();
            }
        }
    }

    public static void paintUnderLine(JLabel l, Graphics g, int underLine) {
        String text;
        if (underLine > 0 && (text = l.getText()).length() > 0) {
            g.setForeground(AwtConverter.fromAwt(l.getForeground()));
            FontMetrics fm = AwtConverter.fromAwt(l.getFontMetrics(l.getFont()));
            int y1 = fm.getHeight() - fm.getDescent() + 1;
            if (underLine == FontUtils.UNDERLINE_STRIKETHROUGH) {
                y1 = l.getHeight() / 2;
            }
            int x2 = fm.stringWidth(text);
            int x = 0;
            if (l.getIcon() != null) {
                x = l.getIcon().getIconWidth() + l.getIconTextGap();
            }
            g.drawLine(x, y1, x + x2, y1);
        }
    }

    public final void cleanUp() {
        TreeNode treeNode = this.getRoot();
        if (treeNode != null) {
            treeNode.unload();
            treeNode.removeListeners();
        }
    }

    @Override
    public void setPeer(Peer peer) {
        super.setPeer(peer);
        this.init();
    }

    public void setPopupEnabled(boolean enabled) {
        this.popupEnabled = enabled;
    }

    public boolean isPopupEnabled() {
        return this.popupEnabled;
    }

    public final void addSelectionPath(TreePath path) {
        this.getTreePeer().addSelectionPath(path);
    }

    public final void addTreeExpansionListener(TreeExpansionListener listener) {
        this.getTreePeer().addTreeExpansionListener(listener);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.getTreePeer().addTreeModelListener(listener);
    }

    public final void addTreeSelectionListener(TreeSelectionListener listener) {
        this.getTreePeer().addTreeSelectionListener(listener);
    }

    public void allNodesChanges() {
        Tree.allNodesChanged(this);
    }

    public void appendChildInto(TreeNode newChild, TreeNode parent) {
        if (!parent.isLoaded()) {
            return;
        }
        this.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void appendChildInto(TreeNode newChild, TreeNode parent, boolean scrollAndSelect) {
        if (!parent.isLoaded()) {
            return;
        }
        this.insertNodeInto(newChild, parent, parent.getChildCount(), scrollAndSelect);
    }

    public void collapseAll() {
        this.getTreePeer().collapseAll();
    }

    public final void collapsePath(TreePath path) {
        this.getTreePeer().collapsePath(path);
    }

    public void expandAll() {
        this.getTreePeer().expandAll();
    }

    public final void expandPath(TreePath path) {
        this.getTreePeer().expandPath(path);
    }

    public void fireNodeChanged(TreeNode node) {
        this.getTreePeer().fireNodeChanged(node);
    }

    public void fireNodeStructureChanged(TreeNode node) {
        this.getTreePeer().fireNodeStructureChanged(node);
    }

    public final TreePath getClosestPathForLocation(int x, int y) {
        return this.getTreePeer().getClosestPathForLocation(x, y);
    }

    public final Iterator<TreePath> getExpandedDescendants(TreePath treePath) {
        return this.getTreePeer().getExpandedDescendants(treePath);
    }

    public final Object getLastSelectedPathComponent() {
        return this.getTreePeer().getLastSelectedPathComponent();
    }

    public final Rectangle getPathBounds(TreePath path) {
        return this.getTreePeer().getPathBounds(path);
    }

    public final TreePath getPathForLocation(int x, int y) {
        return this.getTreePeer().getPathForLocation(x, y);
    }

    public final TreePath getPathForRow(int row) {
        return this.getTreePeer().getPathForRow(row);
    }

    public TreeNode getRoot() {
        return this.getTreePeer().getRoot();
    }

    public Rectangle getRowBounds(int row) {
        return this.getTreePeer().getRowBounds(row);
    }

    public final int getRowCount() {
        return this.getTreePeer().getRowCount();
    }

    public final int getRowForLocation(int x, int y) {
        return this.getTreePeer().getRowForLocation(x, y);
    }

    public final int getRowForPath(TreePath path) {
        return this.getTreePeer().getRowForPath(path);
    }

    public final int getRowHeight() {
        return this.getTreePeer().getRowHeight();
    }

    public TreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object lastPath = path.getLastPathComponent();
        if (lastPath instanceof TreeNode) {
            return (TreeNode)lastPath;
        }
        return null;
    }

    public TreeNode[] getSelectedTreeNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return new TreeNode[0];
        }
        TreeNode[] nodes = new TreeNode[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = (TreeNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    public final int getSelectionCount() {
        return this.getTreePeer().getSelectionCount();
    }

    public final TreePath getSelectionPath() {
        return this.getTreePeer().getSelectionPath();
    }

    public final TreePath[] getSelectionPaths() {
        return this.getTreePeer().getSelectionPaths();
    }

    public final int[] getSelectionRows() {
        return this.getTreePeer().getSelectionRows();
    }

    public void insertNodeInto(TreeNode newChild, TreeNode parent, int index) {
        if (!parent.isLoaded()) {
            return;
        }
        this.insertNodeInto(newChild, parent, index, true);
    }

    public void insertNodeInto(TreeNode newChild, TreeNode parent, int index, boolean scrollAndSelect) {
        newChild.setTree(this);
        if (!parent.isLoaded()) {
            return;
        }
        this.getTreePeer().insertNodeInto(newChild, parent, index);
        if (scrollAndSelect) {
            parent.select();
        }
    }

    public void insertSortedNode(TreeNode newChild, TreeNode parent, Comparator<TreeNode> comparator) {
        this.insertSortedNode(newChild, parent, comparator, true);
    }

    public void insertSortedNode(TreeNode newChild, TreeNode parent, Comparator<TreeNode> comparator, boolean scrollAndSelect) {
        if (parent.isLoaded()) {
            int indexToInsert = 0;
            for (TreeNode node : parent) {
                if (comparator.compare(newChild, node) < 0) break;
                ++indexToInsert;
            }
            this.insertNodeInto(newChild, parent, indexToInsert, scrollAndSelect);
        }
    }

    public final boolean isCollapsed(TreePath path) {
        return this.getTreePeer().isCollapsed(path);
    }

    public final boolean isExpanded(TreePath path) {
        return this.getTreePeer().isExpanded(path);
    }

    public final boolean isExpanded(int row) {
        return this.getTreePeer().isExpanded(row);
    }

    public boolean isMultipleSelection() {
        TreePath[] paths = this.getSelectionPaths();
        return paths != null && paths.length > 1;
    }

    public final boolean isPathSelected(TreePath path) {
        return this.getTreePeer().isPathSelected(path);
    }

    public final boolean isRowSelected(int row) {
        return this.getTreePeer().isRowSelected(row);
    }

    public boolean isShowsRootHandles() {
        return this.getTreePeer().isShowsRootHandles();
    }

    public void reload() {
        TreeNode root = this.getRoot();
        if (root != null) {
            root.reload();
        }
    }

    public void reloadModel() {
        this.getTreePeer().reloadModel();
    }

    public void removeNodeFromParent(TreeNode node) {
        this.getTreePeer().removeNodeFromParent(node);
    }

    public final void removeSelectionPath(TreePath path) {
        this.getTreePeer().removeSelectionPath(path);
    }

    public final void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.getTreePeer().removeTreeSelectionListener(listener);
    }

    public final void scrollPathToVisible(TreePath path) {
        this.getTreePeer().scrollPathToVisible(path);
    }

    public final void scrollRowToVisible(int row) {
        this.getTreePeer().scrollRowToVisible(row);
    }

    public void setAutoscrolls(boolean autoscrolls) {
        this.getTreePeer().setAutoscrolls(autoscrolls);
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getTreePeer().setCellRenderer(renderer);
    }

    public void setColorProvider(ColorProvider provider) {
        if (provider != null) {
            this.getTreePeer().setColorProvider(provider);
        } else {
            this.initColorRenderer();
        }
    }

    public ColorProvider getColorProvider() {
        return this.getTreePeer().getColorProvider();
    }

    public final void setExpandsSelectedPaths(boolean expand) {
        this.getTreePeer().setExpandsSelectedPaths(expand);
    }

    public void setFontProvider(FontProvider provider) {
        if (provider != null) {
            this.getTreePeer().setFontProvider(provider);
        } else {
            this.initFontRenderer();
        }
    }

    public FontProvider getFontProvider() {
        return this.getTreePeer().getFontProvider();
    }

    public void setLabelProvider(LabelProvider provider) {
        if (provider != null) {
            this.getTreePeer().setLabelProvider(provider);
        } else {
            this.initIconRenderer();
        }
    }

    public LabelProvider getLabelProvider() {
        return this.getTreePeer().getLabelProvider();
    }

    public void setRoot(TreeNode node) {
        if (this.isDisposed()) {
            throw new IllegalStateException("Cannot change root node to disposed tree");
        }
        if (node != null) {
            node.setTree(this);
        }
        this.getTreePeer().setRoot(node);
        this.expandRoot();
        this.selectRoot();
    }

    public void expandRoot() {
        TreePath rootPath = this.getRootPath();
        if (rootPath != null) {
            this.expandPath(rootPath);
        }
    }

    public void selectRoot() {
        TreePath rootPath = this.getRootPath();
        if (rootPath != null) {
            this.setSelectionPath(rootPath);
        }
    }

    public final void setRootVisible(boolean visible) {
        this.getTreePeer().setRootVisible(visible);
    }

    public final boolean isRootVisible() {
        return this.getTreePeer().isRootVisible();
    }

    public void setRowHeight(int rowHeight) {
        this.getTreePeer().setRowHeight(rowHeight);
    }

    public final void setSelectionMode(TreeSelectionMode selectionMode) {
        this.getTreePeer().setSelectionMode(selectionMode);
    }

    public final void setSelectionModel(TreeSelectionModel selectionModel) {
        this.getTreePeer().setSelectionModel(selectionModel);
    }

    public final void setSelectionPath(TreePath path) {
        this.getTreePeer().setSelectionPath(path);
    }

    public final void setSelectionPaths(TreePath[] selectionPaths) {
        this.getTreePeer().setSelectionPaths(selectionPaths);
    }

    public final void setSelectionRow(int row) {
        this.getTreePeer().setSelectionRow(row);
    }

    public final void setShowsRootHandles(boolean b) {
        this.getTreePeer().setShowsRootHandles(b);
    }

    public final void setToggleClickCount(int count) {
        this.getTreePeer().setToggleClickCount(count);
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
        TreeNode root = this.getRoot();
        this.translate(root);
    }

    public void translate(TreeNode node) {
        if (node != null) {
            node.nodeChanged();
            if (node.isLoaded()) {
                for (TreeNode child : node) {
                    this.translate(child);
                }
            }
        }
    }

    protected void buildMultiplePopup(MouseEvent e) {
    }

    protected void buildPopup(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        PopupMenu menu = null;
        if (path == null) {
            this.setSelectionPath(null);
        } else {
            this.setSelectionPath(path);
            Object lastPathComponent = path.getLastPathComponent();
            if (lastPathComponent instanceof TreeNode) {
                TreeNode node = (TreeNode)lastPathComponent;
                menu = node.getPopup();
            }
        }
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    protected Peer createPeer() {
        return this.scrollable ? this.getUiFactory().createScrollableTree(this.getParentPeer(), ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED) : this.getUiFactory().createTree(this.getParentPeer());
    }

    protected void doubleClick(MouseEvent e) {
        this.setSelectionPath(this.getPathForLocation(e.getX(), e.getY()));
        TreeNode node = this.getSelectedTreeNode();
        if (node != null) {
            node.doubleClick(e);
        }
    }

    protected void init() {
        assert (!this.isInitialized());
        this.registerVisibilityListener();
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path;
                Object lastComponent;
                if (!Tree.this.isShowsRootHandles() && (lastComponent = (path = event.getPath()).getLastPathComponent()) instanceof TreeNode && ((TreeNode)lastComponent).isRoot()) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Tree.this.doubleClick(e);
                    return;
                }
                if (MouseEventUtilities.isPopupTrigger(e)) {
                    boolean popupEnabled = Tree.this.isPopupEnabled();
                    if (popupEnabled) {
                        if (Tree.this.isMultipleSelection()) {
                            Tree.this.buildMultiplePopup(e);
                        } else {
                            Tree.this.singleClick(e);
                            Tree.this.buildPopup(e);
                        }
                    }
                } else {
                    Tree.this.singleClick(e);
                }
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                Tree.this.doubleClick(e);
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Tree.this.processSelectNode(e);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String s = Integer.toHexString(e.getKeyCode());
                if (e.isDelete()) {
                    Tree.this.deletePressed();
                    e.consume();
                }
            }
        });
        this.initIconRenderer();
        this.initFontRenderer();
        this.initColorRenderer();
        this.setToggleClickCount(-1);
        this.setInitialized(true);
    }

    protected void processSelectNode(TreeSelectionEvent e) {
        if (this.getSelectedTreeNode() != null) {
            this.getSelectedTreeNode().onSelection(e);
        }
    }

    protected void singleClick(MouseEvent e) {
        Object node = this.getLastSelectedPathComponent();
        if (node instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)node;
            treeNode.onMouseSelection(e);
        }
    }

    protected boolean useTip(Object value) {
        return true;
    }

    private void deletePressed() {
        Object node = this.getLastSelectedPathComponent();
        if (node instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)node;
            treeNode.deletePressed();
        }
    }

    private void registerVisibilityListener() {
        this.addVisibilityListener(new VisibilityListener(){

            @Override
            public void onDispose() {
                Tree.this.cleanUp();
            }
        });
    }

    private void removeListeners() {
    }

    private void initColorRenderer() {
        this.setColorProvider(new ColorProvider.Default(){

            @Override
            public Color getForeground(Object element) {
                TreeNode node;
                Color result = null;
                if (element instanceof TreeNode && (node = (TreeNode)element).getColorModifiers() != Color.BLACK.getRGB()) {
                    result = Color.valueOf(node.getColorModifiers());
                }
                return result;
            }
        });
    }

    private void initFontRenderer() {
        this.setFontProvider(new FontProvider(){

            public Font getFont(Object element) {
                TreeNode node;
                FontStyle fontModifiers;
                Font result = UiManager.font("Tree.font");
                if (element instanceof TreeNode && (fontModifiers = (node = (TreeNode)element).getFontModifiers()) != null) {
                    result = Tree.this.getFont().applyStyle(fontModifiers);
                }
                return result;
            }
        });
    }

    private void initIconRenderer() {
        this.setLabelProvider(new LabelProvider.Default(){

            @Override
            public Image getIcon(Object element) {
                Image result = null;
                if (element instanceof TreeNode) {
                    TreeNode node = (TreeNode)element;
                    result = node.getIcon();
                }
                return result;
            }

            @Override
            public String getText(Object element) {
                if (element instanceof TreeNode) {
                    return ((TreeNode)element).getText();
                }
                return element.toString();
            }
        });
    }

    private void addTreeWillExpandListener(TreeWillExpandListener listener) {
        this.getTreePeer().addTreeWillExpandListener(listener);
    }

    private TreePath getRootPath() {
        TreeNode root = this.getRoot();
        TreePath result = root != null ? TreePath.createSinglePath(root) : null;
        return result;
    }

    private TreePeer getTreePeer() {
        return (TreePeer)this.getPeer();
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

