/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import javax.swing.InputMap;
import javax.swing.JComponent;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class MutableTree
extends Tree {
    static final long serialVersionUID = 8590409439157700076L;
    static final long serialCheck = 3531672527070646570L;

    public MutableTree(UiContainer parent) {
        super(parent);
    }

    public TreeNode findNodeToSelectAfterDelete(TreeNode nodeToDelete) {
        TreeNode parent = nodeToDelete.getParent();
        TreeNode nextNode = null;
        if (parent != null) {
            nextNode = parent.getChildAfter(nodeToDelete);
            if (nextNode == null) {
                nextNode = parent.getChildBefore(nodeToDelete);
            }
            if (nextNode == null) {
                nextNode = parent;
            }
        }
        return nextNode;
    }

    protected void deletePressed() {
        int selectionCount = this.getSelectionCount();
        if (selectionCount == 1) {
            this.singleDelete();
        } else if (selectionCount > 1) {
            this.multipleDelete();
        }
    }

    protected void enterPressed() {
        int selectionCount = this.getSelectionCount();
        if (selectionCount == 1) {
            this.singleEnter();
        } else if (selectionCount > 1) {
            this.multipleEnter();
        }
        this.singleEnter();
    }

    @Override
    protected void init() {
        super.init();
        if (this.getNative() instanceof JComponent) {
            this.addKeyListeners();
        }
    }

    protected boolean multipleDelete() {
        for (TreeNode element : this.getSelectedTreeNodes()) {
            if (element.delete()) continue;
            return false;
        }
        return true;
    }

    protected void multipleEnter() {
        for (TreeNode element : this.getSelectedTreeNodes()) {
            element.doubleClick(MouseEvent.createClick(this));
        }
    }

    protected boolean singleDelete() {
        TreeNode node = this.getSelectedTreeNode();
        boolean result = false;
        if (node != null) {
            TreeNode nextNode = this.findNodeToSelectAfterDelete(node);
            result = node.delete();
            if (result && nextNode != null) {
                nextNode.select();
            }
        }
        return result;
    }

    protected void singleEnter() {
        TreeNode node = this.getSelectedTreeNode();
        if (node != null) {
            node.doubleClick(MouseEvent.createClick(this));
        }
    }

    @Override
    protected boolean useTip(Object value) {
        return false;
    }

    private void addKeyListeners() {
        boolean noModifiers = false;
        String DELETE_ACTION_KEY = "DELETE_ACTION_KEY";
        String ENTER_ACTION_KEY = "ENTER_ACTION_KEY";
        KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0, false);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(deleteKey.asSwing(), "DELETE_ACTION_KEY");
        inputMap.put(enterKey.asSwing(), "ENTER_ACTION_KEY");
        BaseAction deleteAction = new BaseAction(){

            @Override
            public void run() {
                try {
                    MutableTree.this.deletePressed();
                }
                catch (Exception ex) {
                    MessageDialog.showError(ex);
                }
            }
        };
        BaseAction enterAction = new BaseAction(){

            @Override
            public void run() {
                try {
                    MutableTree.this.enterPressed();
                }
                catch (Exception ex) {
                    MessageDialog.showError(ex);
                }
            }
        };
        this.getActionMap().put("DELETE_ACTION_KEY", deleteAction);
        this.getActionMap().put("ENTER_ACTION_KEY", enterAction);
    }
}

