/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.tree;

import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.peer.CheckTreePeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.Tree;

public class CheckTree
extends Tree {
    public CheckTree(UiContainer parent) {
        super(parent);
    }

    public CheckTree(UiContainer parent, Object[] nodes) {
        super(parent);
        CheckTreeNode root = new CheckTreeNode("");
        for (Object node : nodes) {
            root.add(new CheckTreeNode(node));
        }
        this.setRoot(root);
    }

    public CheckTree(UiContainer parent, CheckTreeNode root) {
        super(parent, root);
    }

    @Override
    public void reload() {
        super.reload();
        this.getCheckTreePeer().refresh();
    }

    @Override
    public CheckTreeNode getRoot() {
        return (CheckTreeNode)super.getRoot();
    }

    public void addCheckSelectionListener(CheckSelectionListener listener) {
        this.getCheckTreePeer().addCheckSelectionListener(listener);
    }

    public void removeCheckSelectionListener(CheckSelectionListener listener) {
        this.getCheckTreePeer().removeCheckSelectionListener(listener);
    }

    public void updateNodeSelectionState(CheckTreeNode checkTreeNode) {
        this.getCheckTreePeer().updateNodeCheckState(checkTreeNode);
    }

    public void fireNodeSelectedStateChanged(CheckTreeNode checkTreeNode) {
        this.getCheckTreePeer().fireNodeSelectedStateChanged(checkTreeNode);
    }

    public void fireChildrenSelectedStateChanged(CheckTreeNode checkTreeNode) {
        this.getCheckTreePeer().fireChildrenSelectedStateChanged(checkTreeNode);
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createCheckTree(this.getParentPeer());
    }

    private CheckTreePeer getCheckTreePeer() {
        return (CheckTreePeer)this.getPeer();
    }
}

