/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text.filter;

import oracle.bpm.ui.text.filter.LimitFilter;

public class ValidFileFilter
extends LimitFilter {
    protected String forbidden = ";,+|?<>:/\\*\"";
    private String[] reservedFileNames = new String[]{"AUX", "CON", "NUL", "PNR", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public ValidFileFilter(int limit) {
        this(limit, true);
    }

    public ValidFileFilter(int limit, boolean acceptSpaces) {
        super(limit);
        if (!acceptSpaces) {
            this.forbidden = this.forbidden + " ";
        }
    }

    @Override
    public boolean accepts(String str, int offs) {
        if (!super.accepts(str, offs)) {
            return false;
        }
        if (!this.checkDots(str)) {
            return false;
        }
        if (!this.checkForbiddenCharacters(str)) {
            return false;
        }
        return this.checkReservedFileNames(str);
    }

    @Override
    public String filter(String str, int offs) {
        if ((str = super.filter(str, offs)) != null && str.length() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                if (this.forbidden.indexOf(str.charAt(i)) != -1) continue;
                buffer.append(str.charAt(i));
            }
            return buffer.toString();
        }
        return str;
    }

    private boolean checkReservedFileNames(String str) {
        for (String reservedFileName : this.reservedFileNames) {
            if (!reservedFileName.equals(str.toUpperCase())) continue;
            return false;
        }
        return true;
    }

    private boolean checkForbiddenCharacters(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (this.forbidden.indexOf(ch) == -1) continue;
            return false;
        }
        return true;
    }

    private boolean checkDots(String str) {
        return !str.startsWith(".") && !str.endsWith(".");
    }
}

