/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import javax.swing.SwingConstants;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;

public class BasicArrowButton
extends Button
implements SwingConstants {
    protected int direction;

    public BasicArrowButton(UiContainer parent, int i) {
        super(parent);
        this.setDirection(i);
        this.setBackground(UiManager.color("control"));
        this.setMaximumSize(Dimension.valueOf(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void setDirection(int i) {
        this.direction = i;
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public Dimension getMinimumSize() {
        return Dimension.valueOf(5, 5);
    }

    @Override
    public Dimension getPreferredSize() {
        return Dimension.valueOf(16, 16);
    }

    @Override
    public void paint(Graphics g) {
        int i = this.getSize().getWidth();
        int j = this.getSize().getHeight();
        Color color = g.getForeground();
        boolean flag = this.isPressed();
        boolean flag1 = this.isEnabled();
        g.setForeground(this.getBackground());
        g.fillRect(1, 1, i - 2, j - 2);
        if (flag) {
            g.setForeground(UiManager.color("controlShadow"));
            g.drawRect(0, 0, i - 1, j - 1);
        } else {
            g.drawLine(0, 0, 0, j - 1);
            g.drawLine(1, 0, i - 2, 0);
            g.setForeground(UiManager.color("controlHighlight"));
            g.drawLine(1, 1, 1, j - 3);
            g.drawLine(2, 1, i - 3, 1);
            g.setForeground(UiManager.color("controlShadow"));
            g.drawLine(1, j - 2, i - 2, j - 2);
            g.drawLine(i - 2, 1, i - 2, j - 3);
            g.setForeground(UiManager.color("controlDkShadow"));
            g.drawLine(0, j - 1, i - 1, j - 1);
            g.drawLine(i - 1, j - 1, i - 1, 0);
        }
        if (j < 5 || i < 5) {
            g.setForeground(color);
            return;
        }
        if (flag) {
            g.translate(1, 1);
        }
        int k = Math.min((j - 4) / 3, (i - 4) / 3);
        k = Math.max(k, 2);
        this.paintTriangle(g, (i - k) / 2, (j - k) / 2, k, this.direction, flag1);
        if (flag) {
            g.translate(-1, -1);
        }
        g.setForeground(color);
    }

    public void paintTriangle(Graphics g, int i, int j, int k, int l, boolean flag) {
        Color color = g.getForeground();
        int l2 = 0;
        k = Math.max(k, 3);
        int i1 = k / 2;
        g.translate(i, j);
        g.setForeground(UiManager.color(flag ? "controlDkShadow" : "controlShadow"));
        switch (l) {
            default: {
                break;
            }
            case 1: {
                int j1;
                for (j1 = 0; j1 < k; ++j1) {
                    g.drawLine(i1 - j1, j1, i1 + j1, j1);
                }
                if (flag) break;
                g.setForeground(UiManager.color("controlHighlight"));
                g.drawLine(i1 - j1 + 2, j1, i1 + j1, j1);
                break;
            }
            case 5: {
                if (!flag) {
                    g.translate(1, 1);
                    g.setForeground(UiManager.color("controlHighlight"));
                    for (int k1 = k - 1; k1 >= 0; --k1) {
                        g.drawLine(i1 - k1, l2, i1 + k1, l2);
                        ++l2;
                    }
                    g.translate(-1, -1);
                    g.setForeground(UiManager.color("controlShadow"));
                }
                l2 = 0;
                for (int l1 = k - 1; l1 >= 0; --l1) {
                    g.drawLine(i1 - l1, l2, i1 + l1, l2);
                    ++l2;
                }
                break;
            }
            case 7: {
                int i2;
                for (i2 = 0; i2 < k; ++i2) {
                    g.drawLine(i2, i1 - i2, i2, i1 + i2);
                }
                if (flag) break;
                g.setForeground(UiManager.color("controlHighlight"));
                g.drawLine(i2, i1 - i2 + 2, i2, i1 + i2);
                break;
            }
            case 3: {
                if (!flag) {
                    g.translate(1, 1);
                    g.setForeground(UiManager.color("controlHighlight"));
                    for (int j2 = k - 1; j2 >= 0; --j2) {
                        g.drawLine(l2, i1 - j2, l2, i1 + j2);
                        ++l2;
                    }
                    g.translate(-1, -1);
                    g.setForeground(UiManager.color("controlShadow"));
                }
                l2 = 0;
                for (int k2 = k - 1; k2 >= 0; --k2) {
                    g.drawLine(l2, i1 - k2, l2, i1 + k2);
                    ++l2;
                }
            }
        }
        g.translate(-i, -j);
        g.setForeground(color);
    }

    @Override
    public void requestFocus() {
    }
}

