/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import java.util.ArrayList;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.List;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.AutoComplete;
import oracle.bpm.ui.text.AutoCompleteDictionary;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.ArrayUtils;

public class AutoCompleteTextPanel
extends Panel
implements AutoComplete {
    public List list;
    public MutableListListModel model;
    public TextField text;
    protected boolean autoComplete = true;
    private AutoCompleteDictionary dict;
    private java.util.List<WordFoundListener> wordListeners;

    public AutoCompleteTextPanel(UiContainer parent, AutoCompleteDictionary dict) {
        super(parent);
        this.setDictionary(dict);
        this.buildUI();
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    public void removeAllItems() {
        this.model.removeAllElements();
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public String getItemAt(int index) {
        return (String)this.model.getElementAt(index);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.text.requestFocus();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    @Override
    public void setAutoComplete(boolean val) {
        this.autoComplete = val;
    }

    @Override
    public boolean getAutoComplete() {
        return this.autoComplete;
    }

    @Override
    public void setDictionary(AutoCompleteDictionary dict) {
        this.dict = dict;
    }

    @Override
    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public void addWordFoundListener(WordFoundListener listener) {
        this.getWordListeners().add(listener);
    }

    public void addItem(String item) {
        if (!this.model.contains(item)) {
            this.model.addElement(item);
        }
    }

    public String getSelectedItem() {
        return (String)this.list.getSelectedValue();
    }

    public void setSelectedItem(String o) {
        this.text.setText(o);
        this.list.setSelectedValue(o, true);
        if (o != null) {
            this.text.setForeground(Color.BLACK);
        }
    }

    protected void fillComboWithFoundItems(String[] strings) {
        for (String string : strings) {
            this.addItem(string);
        }
    }

    protected void fireWordFound(String s, String[] strings) {
        for (WordFoundListener wordFoundListener : this.getWordListeners()) {
            wordFoundListener.wordsFound(s, strings);
        }
    }

    private void buildUI() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout(layout);
        this.text = new TextField(this);
        this.model = new MutableListListModel((java.util.List)new ArrayList());
        this.list = new List((UiContainer)this, this.model);
        this.addListenersForUpAndDownKeys();
        this.add(this.text, "text");
        this.add(this.list, "list");
        layout.addConstraint("text", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("text", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("text", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("list", AttributeType.TOP, new AttributeConstraint("text", AttributeType.BOTTOM));
        layout.addConstraint("list", AttributeType.LEFT, new AttributeConstraint("text", AttributeType.LEFT));
        layout.addConstraint("list", AttributeType.RIGHT, new AttributeConstraint("text", AttributeType.RIGHT));
        this.text.addKeyListener(new FieldKeyListener(this.text));
    }

    private void addListenersForUpAndDownKeys() {
        this.text.addKeyListener(new KeyListener.Default(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isDown() && AutoCompleteTextPanel.this.text.hasFocus()) {
                    AutoCompleteTextPanel.this.list.grabFocus();
                }
            }
        });
        this.list.addKeyListener(new KeyListener.Default(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isUp() && AutoCompleteTextPanel.this.list.hasFocus() && AutoCompleteTextPanel.this.list.getSelectedIndex() == 0) {
                    AutoCompleteTextPanel.this.text.grabFocus();
                }
            }
        });
    }

    private java.util.List<WordFoundListener> getWordListeners() {
        if (this.wordListeners == null) {
            this.wordListeners = new ArrayList<WordFoundListener>();
        }
        return this.wordListeners;
    }

    private String[] lookup(String s) {
        if (this.getDictionary() != null) {
            Object[] strings = this.getDictionary().lookup(s);
            this.removeAllItems();
            this.list.revalidate();
            if (ArrayUtils.isNullOrEmtpy(strings)) {
                return null;
            }
            this.fireWordFound(s, (String[])strings);
            this.fillComboWithFoundItems((String[])strings);
            return strings;
        }
        return null;
    }

    private final class FieldKeyListener
    extends KeyAdapter {
        private final TextField textField;

        private FieldKeyListener(TextField textField) {
            this.textField = textField;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String itemAt;
            int selectedIndex;
            if (e.isDelete() || e.isUndefined() || e.isControlDown() || e.isActionKey()) {
                return;
            }
            if (e.isEnter() && (selectedIndex = AutoCompleteTextPanel.this.list.getSelectedIndex()) > -1 && (itemAt = (String)AutoCompleteTextPanel.this.model.getElementAt(selectedIndex)) != null) {
                this.textField.setText(itemAt);
                return;
            }
            if (this.textField.getSelectionStart() != this.textField.getSelectionEnd()) {
                this.textField.setText(this.textField.getText().substring(0, this.textField.getSelectionStart()));
            }
            String input = this.textField.getText();
            this.textField.setForeground(Color.BLACK);
            Object[] strings = AutoCompleteTextPanel.this.lookup(input);
            if (!ArrayUtils.isNullOrEmtpy(strings)) {
                this.textField.setText((String)strings[0]);
                this.textField.setSelectionStart(input.length());
                this.textField.setSelectionEnd(this.textField.getText().length());
            } else {
                this.textField.setForeground(Color.RED);
                AutoCompleteTextPanel.this.addItem(input);
                this.textField.setText(input);
                this.textField.setCaretPosition(input.length());
                AutoCompleteTextPanel.this.repaint();
            }
            if (e.isBackSpace() && input.length() > 0) {
                this.textField.setText(input);
                this.textField.setCaretPosition(input.length());
            }
        }
    }

    public static interface WordFoundListener {
        public void wordsFound(String var1, String[] var2);
    }
}

