/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.text.AutoComplete;
import oracle.bpm.ui.text.AutoCompleteDictionary;
import oracle.bpm.ui.text.MultipleValuesDictionary;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.ArrayUtils;

public class AutoCompleteTextField
extends TextField
implements AutoComplete {
    protected boolean autoComplete = true;
    private AutoCompleteDictionary dict;
    private MutableListListModel model;
    private PopupMenu popupList;

    public AutoCompleteTextField(UiContainer parent, AutoCompleteDictionary dict) {
        super(parent);
        this.setDictionary(dict);
        this.buildUI();
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWING);
        Frame frame = new Frame("AutoCompleteTextField Test");
        frame.setDefaultCloseOperation(3);
        UiContainer contentPane = frame.getContentPane();
        Panel panel = new Panel(contentPane);
        contentPane.add(panel, "Center");
        Label label = Label.create(panel);
        label.setText("Type a value and press the Down key to open the list: ");
        panel.add(label);
        MultipleValuesDictionary dict = new MultipleValuesDictionary();
        dict.addEntry("one");
        dict.addEntry("two");
        dict.addEntry("three");
        dict.addEntry("three.three");
        AutoCompleteTextField text = new AutoCompleteTextField((UiContainer)panel, dict);
        panel.add(text);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    @Override
    public void setAutoComplete(boolean val) {
        this.autoComplete = val;
    }

    @Override
    public boolean getAutoComplete() {
        return this.autoComplete;
    }

    @Override
    public void setDictionary(AutoCompleteDictionary dict) {
        this.dict = dict;
    }

    @Override
    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public boolean isValidInput() {
        if (this.dict == null) {
            return true;
        }
        String[] validValues = this.dict.lookup(this.getText());
        if (validValues != null) {
            for (String s : validValues) {
                if (!s.equals(this.getText())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.paintValidForegroundColor();
    }

    private void buildUI() {
        this.model = new MutableListListModel((List)new ArrayList());
        this.popupList = new PopupMenu();
        this.addModelListeners();
        this.addKeyListeners();
    }

    private void addModelListeners() {
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent event) {
                AutoCompleteTextField.this.refreshPopupList();
            }

            @Override
            public void intervalRemoved(ListDataEvent event) {
                AutoCompleteTextField.this.refreshPopupList();
            }

            @Override
            public void contentsChanged(ListDataEvent event) {
            }
        });
    }

    private void refreshPopupList() {
        this.popupList.removeAll();
        for (int i = 0; i < this.model.getSize(); ++i) {
            this.popupList.add(new BaseAction((String)this.model.getElementAt(i)){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AutoCompleteTextField.this.setText(this.getMsg().toString());
                    AutoCompleteTextField.this.paintValidForegroundColor();
                }
            });
        }
    }

    private void paintValidForegroundColor() {
        this.setForeground(this.isValidInput() ? Color.BLACK : Color.RED);
    }

    private void addKeyListeners() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isDown() && AutoCompleteTextField.this.hasFocus() && AutoCompleteTextField.this.model.getSize() > 0 && !AutoCompleteTextField.this.getText().isEmpty()) {
                    AutoCompleteTextField.this.popupList.show(AutoCompleteTextField.this, 0, AutoCompleteTextField.this.getHeight());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object[] strings;
                if (e.isUndefined() || e.isControlDown() || e.isActionKey()) {
                    return;
                }
                AutoCompleteTextField.this.popupList.setVisible(false);
                if (e.isEscape() || e.isEnter()) {
                    AutoCompleteTextField.this.setCaretPosition(AutoCompleteTextField.this.getText().length());
                    return;
                }
                boolean shouldAutocomplete = AutoCompleteTextField.this.autoComplete;
                String input = AutoCompleteTextField.this.getText();
                if (e.isBackSpace() || e.isDelete()) {
                    int caretPosition = AutoCompleteTextField.this.getCaretPosition();
                    AutoCompleteTextField.this.setText(input);
                    shouldAutocomplete = false;
                    AutoCompleteTextField.this.setCaretPosition(caretPosition);
                }
                if (input.length() > 0 && AutoCompleteTextField.this.getDictionary() != null && !ArrayUtils.isNullOrEmtpy(strings = AutoCompleteTextField.this.lookup(input)) && shouldAutocomplete) {
                    AutoCompleteTextField.this.setText((String)strings[0]);
                    AutoCompleteTextField.this.setSelectionStart(input.length());
                    AutoCompleteTextField.this.setSelectionEnd(AutoCompleteTextField.this.getText().length());
                }
                AutoCompleteTextField.this.paintValidForegroundColor();
            }
        });
    }

    private String[] lookup(String s) {
        Object[] strings = this.getDictionary().lookup(s);
        this.model.removeAllElements();
        if (ArrayUtils.isNullOrEmtpy(strings)) {
            return null;
        }
        this.fillPopupWithFoundItems((String[])strings);
        return strings;
    }

    private void fillPopupWithFoundItems(String[] strings) {
        for (String string : strings) {
            if (this.model.contains(string)) continue;
            this.model.addElement(string);
        }
    }
}

