/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table.editors;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.bpm.lang.Cast;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.table.editors.BaseTextFieldEditor;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextComponent;

public abstract class NumericFieldCellEditor
extends BaseTextFieldEditor {
    private boolean showSpinner = true;

    public static IntegerFieldCellEditor createIntegerCellEditor() {
        return new IntegerFieldCellEditor();
    }

    public static LongFieldCellEditor createLongCellEditor() {
        return new LongFieldCellEditor();
    }

    public static DoubleFieldCellEditor createDoubleCellEditor() {
        return new DoubleFieldCellEditor();
    }

    public static FloatFieldCellEditor createFloatCellEditor() {
        return new FloatFieldCellEditor();
    }

    public static ShortFieldCellEditor createShortCellEditor() {
        return new ShortFieldCellEditor();
    }

    public static BigIntegerFieldCellEditor createBigIntegerCellEditor() {
        return new BigIntegerFieldCellEditor();
    }

    public static BigDecimalFieldCellEditor createBigDecimalCellEditor() {
        return new BigDecimalFieldCellEditor();
    }

    public void setShowSpinner(boolean showSpinner) {
        this.showSpinner = showSpinner;
    }

    public boolean isShowSpinner() {
        return this.showSpinner;
    }

    @Override
    public void setValue(Object value) {
        NumericField editor = (NumericField)Cast.force(this.getNumericField());
        if (editor != null) {
            editor.setValue((Number)value);
        }
    }

    @Override
    public Object getCellEditorValue() {
        NumericField<? extends Number> editor = this.getNumericField();
        return editor == null ? (Number)null : (Number)editor.getValue();
    }

    protected abstract NumericField<? extends Number> createNumericField(UiContainer var1);

    @Override
    protected TextComponent createEditor(UiContainer parent) {
        NumericField<? extends Number> editor = this.createNumericField(parent);
        editor.setColumns(this.getColumns());
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumericFieldCellEditor.this.stopCellEditing();
            }
        });
        return editor;
    }

    protected NumericField<? extends Number> getNumericField() {
        return (NumericField)this.getEditor();
    }

    private static class ShortFieldCellEditor
    extends NumericFieldCellEditor {
        private ShortFieldCellEditor() {
        }

        protected NumericField<Short> createNumericField(UiContainer parent) {
            return NumericField.createShortNumericField(parent);
        }
    }

    private static class LongFieldCellEditor
    extends NumericFieldCellEditor {
        private LongFieldCellEditor() {
        }

        protected NumericField<Long> createNumericField(UiContainer parent) {
            return NumericField.createLongNumericField(parent);
        }
    }

    private static class IntegerFieldCellEditor
    extends NumericFieldCellEditor {
        private IntegerFieldCellEditor() {
        }

        protected NumericField<Integer> createNumericField(UiContainer parent) {
            NumericField<Integer> numericField = NumericField.createIntegerNumericField(parent, false);
            numericField.setMinimum(Integer.MIN_VALUE);
            return numericField;
        }
    }

    private static class FloatFieldCellEditor
    extends NumericFieldCellEditor {
        private FloatFieldCellEditor() {
        }

        protected NumericField<Float> createNumericField(UiContainer parent) {
            return NumericField.createFloatNumericField(parent);
        }
    }

    private static class DoubleFieldCellEditor
    extends NumericFieldCellEditor {
        private DoubleFieldCellEditor() {
        }

        protected NumericField<Double> createNumericField(UiContainer parent) {
            return NumericField.createDoubleNumericField(parent);
        }
    }

    private static class BigIntegerFieldCellEditor
    extends NumericFieldCellEditor {
        private BigIntegerFieldCellEditor() {
        }

        protected NumericField<BigInteger> createNumericField(UiContainer parent) {
            return NumericField.createBigIntegerNumericField(parent);
        }
    }

    private static class BigDecimalFieldCellEditor
    extends NumericFieldCellEditor {
        private BigDecimalFieldCellEditor() {
        }

        protected NumericField<BigDecimal> createNumericField(UiContainer parent) {
            return NumericField.createBigDecimalNumericField(parent);
        }
    }
}

