/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table.editors;

import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.table.editors.BaseTextFieldEditor;
import oracle.bpm.ui.text.TextComponent;

public class IdentifierTextFieldEditor
extends BaseTextFieldEditor {
    private boolean allowsFirstInUpperCase;

    public IdentifierTextFieldEditor() {
        this.setColumns(0);
        this.setAllowsFirstInUpperCase(false);
    }

    public void setAllowsFirstInUpperCase(boolean allowsFirstInUpperCase) {
        this.allowsFirstInUpperCase = allowsFirstInUpperCase;
    }

    public boolean isAllowsFirstInUpperCase() {
        return this.allowsFirstInUpperCase;
    }

    @Override
    public Object getCellEditorValue() {
        IdentifierTextField editor = this.getIdentifierTextField();
        return editor == null ? null : editor.getText();
    }

    @Override
    protected void setValue(Object value) {
        IdentifierTextField editor = this.getIdentifierTextField();
        if (editor != null) {
            editor.setText(value.toString());
        }
    }

    @Override
    protected TextComponent createEditor(UiContainer parent) {
        IdentifierTextField editor = new IdentifierTextField(parent);
        editor.setColumns(this.getColumns());
        editor.setAllowsFirstInUpperCase(this.isAllowsFirstInUpperCase());
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdentifierTextFieldEditor.this.stopCellEditing();
            }
        });
        return editor;
    }

    private IdentifierTextField getIdentifierTextField() {
        return (IdentifierTextField)this.getEditor();
    }
}

