/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;

public class FocuseableTableCellRendererDecorator
implements TableCellRenderer {
    private TableCellRenderer tableCellRenderer;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    FocuseableTableCellRendererDecorator(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    public static void decorateTableCellRendererComponent(JTable jTable, UiComponent component, boolean isSelected, boolean hasFocus, int row, int column) {
        if (component.getNative() instanceof JComponent) {
            JComponent jComponent = component.asSwing();
            if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setBorderPainted(true);
            }
            if (hasFocus) {
                if (jTable.isCellEditable(row, column)) {
                    jComponent.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    jComponent.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
                jComponent.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                jComponent.setBorder(noFocusBorder.asSwing());
            }
        }
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
        FocuseableTableCellRendererDecorator.decorateTableCellRendererComponent(jTable, UiComponent.get(component), isSelected, hasFocus, row, column);
        return component;
    }
}

