/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTablePanel
extends Panel {
    private BaseAction addAction;
    private BaseAction editAction;
    private BaseAction removeAction;
    private Style style;
    private Table table;

    public BaseTablePanel(UiContainer parent, Msg title) {
        this(parent, title, null);
    }

    public BaseTablePanel(UiContainer parent, Msg title, Msg description) {
        this(parent, title, description, null);
    }

    public BaseTablePanel(UiContainer parent, Msg title, Msg description, TableModel model) {
        this(parent, title, description, model, Style.TOOLBAR_RIGHT);
    }

    public BaseTablePanel(UiContainer parent, Msg title, Msg description, TableModel model, Style style) {
        super(parent, title);
        this.style = style;
        this.init(description, model);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTable().setEnabled(enabled);
        this.removeAction.setEnabled(enabled ? this.getTable().getSelectedRowCount() > 0 : enabled);
        this.editAction.setEnabled(enabled ? this.getTable().getSelectedRowCount() > 0 : enabled);
        this.addAction.setEnabled(enabled);
    }

    @Override
    public Dimension getMinimumSize() {
        return Dimension.valueOf(50, 50);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected abstract void addAction();

    protected void editAction() {
    }

    protected BaseAction getRemoveAction() {
        return this.removeAction;
    }

    protected BaseAction getEditAction() {
        return this.editAction;
    }

    protected void setModel(ProviderTableModel model) {
        this.getTable().setModel(model);
    }

    protected ProviderTableModel getModel() {
        return (ProviderTableModel)this.getTable().getModel();
    }

    protected UiWindow getParentWindow() {
        return this.getOwnerWindow();
    }

    protected Table getTable() {
        return this.table;
    }

    protected BaseAction[] getUserActions() {
        return new BaseAction[0];
    }

    protected void deleteAction() {
        ProviderTableModel model = (ProviderTableModel)this.getTable().getModel();
        int[] selection = this.getTable().getSelectedRows();
        for (int row = selection.length - 1; row >= 0; --row) {
            model.removeRow(selection[row]);
        }
        this.updateSelection(selection);
    }

    protected void updateSelection(int[] selection) {
        int rowCount = this.getModel().getRowCount();
        if (selection.length > 0 && rowCount > 0) {
            int newSelection = selection[0];
            if (selection[0] >= rowCount) {
                newSelection = rowCount - 1;
            }
            this.getTable().setSelectionInterval(newSelection, newSelection);
        }
    }

    protected void stopCellEditor() {
        TableCellEditor editor = this.getTable().getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    protected void selectionChanged(int[] selectedRows) {
        boolean enabled = this.getTable().isEnabled() && selectedRows.length > 0;
        this.removeAction.setEnabled(enabled);
        this.editAction.setEnabled(enabled);
    }

    protected boolean showAddAction() {
        return true;
    }

    protected boolean showEditAction() {
        return false;
    }

    protected boolean showRemoveAction() {
        return true;
    }

    private UiComponent buildToolbarPanel(UiContainer parent, ToolBar.Orientation orientation) {
        ArrayList<BaseAction> actions = new ArrayList<BaseAction>();
        this.appendAddAction(actions);
        this.appendEditAction(actions);
        this.appendRemoveAction(actions);
        this.appendUserActions(actions);
        return this.buildToolBar(parent, actions, orientation);
    }

    private void appendUserActions(List<BaseAction> actions) {
        BaseAction[] userActions = this.getUserActions();
        actions.addAll(Arrays.asList(userActions));
    }

    private void appendRemoveAction(@NotNull List<BaseAction> actions) {
        this.removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                BaseTablePanel.this.stopCellEditor();
                BaseTablePanel.this.deleteAction();
            }
        };
        this.removeAction.setEnabled(false);
        if (this.showRemoveAction()) {
            actions.add(this.removeAction);
        }
    }

    private void appendEditAction(@NotNull List<BaseAction> actions) {
        this.editAction = new BaseAction(UIMsg.EDIT){

            @Override
            public void run() {
                BaseTablePanel.this.stopCellEditor();
                BaseTablePanel.this.editAction();
            }
        };
        this.editAction.setEnabled(false);
        if (this.showEditAction()) {
            actions.add(this.editAction);
        }
    }

    private void appendAddAction(@NotNull List<BaseAction> actions) {
        this.addAction = new BaseAction(UIMsg.ADD){

            @Override
            public void run() {
                BaseTablePanel.this.stopCellEditor();
                BaseTablePanel.this.addAction();
                TableModel tableModel = BaseTablePanel.this.getTable().getModel();
                int lastRow = tableModel.getRowCount() - 1;
                int columnCount = tableModel.getColumnCount();
                if (lastRow >= 0) {
                    for (int i = 0; i < columnCount; ++i) {
                        if (!tableModel.isCellEditable(lastRow, i)) continue;
                        BaseTablePanel.this.table.editCellAt(lastRow, i);
                        return;
                    }
                }
            }
        };
        if (this.showAddAction()) {
            actions.add(this.addAction);
        }
    }

    private UiComponent buildToolBar(UiContainer parent, List<BaseAction> actions, ToolBar.Orientation orientation) {
        ToolBar toolBar = new ToolBar(parent, orientation);
        for (BaseAction action : actions) {
            if (action != null) {
                toolBar.add(action);
                continue;
            }
            toolBar.addSeparator();
        }
        return toolBar;
    }

    private Table buildTable(UiContainer parent, TableModel model) {
        final Table table = new Table(parent, model, ListSelectionMode.SINGLE_INTERVAL_SELECTION);
        table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseTablePanel.this.selectionChanged(table.getSelectedRows());
            }
        });
        table.setColumnHideAllowed(false);
        return table;
    }

    private void init(Msg description, TableModel model) {
        this.setLayout(new BorderLayout(5, 5));
        this.table = this.buildTable(this, model);
        Panel topPanel = new Panel(this);
        topPanel.setLayout(new MigLayout("ins 0, gap 0, fillx"));
        topPanel.add(Label.createWithNoColon(topPanel, description == null ? Msg.QUOTE("") : description), "growx");
        if (this.style == Style.TOOLBAR_TOP) {
            topPanel.add(this.buildToolbarPanel(topPanel, ToolBar.Orientation.HORIZONTAL), "alignx right");
        } else {
            this.add(this.buildToolbarPanel(this, ToolBar.Orientation.VERTICAL), "East");
        }
        this.add(topPanel, "North");
        this.add(this.table, "Center");
    }

    public static enum Style {
        TOOLBAR_TOP,
        TOOLBAR_RIGHT;

    }
}

