/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.table;

import oracle.bpm.ui.event.EventListenerList;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.table.TableModel;

public abstract class AbstractTableModel
implements TableModel {
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    public Iterable<TableModelListener> getTableModelListeners() {
        return this.listenerList.getListenersByType(TableModelListener.class);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columnName.equals(this.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public void fireTableChanged(TableModelEvent e) {
        for (TableModelListener l : this.listenerList.getListenersByType(TableModelListener.class)) {
            l.tableChanged(e);
        }
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }
}

