/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.statusbar;

import java.math.BigDecimal;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.statusbar.StatusMessage;

class MemoryMonitor {
    private StatusMessage statusMessage_d;

    public MemoryMonitor(StatusMessage statusMessage) {
        this.statusMessage_d = statusMessage;
        this.setMessage();
        Timer timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UiUtilities.isEventDispatchThread()) {
                    MemoryMonitor.this.setMessage();
                } else {
                    UiUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MemoryMonitor.this.setMessage();
                        }
                    });
                }
            }
        });
        timer.start();
    }

    public void setMessage() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        BigDecimal totalMB = new BigDecimal((double)total / 1024.0 / 1024.0);
        totalMB = totalMB.setScale(1, 4);
        BigDecimal usedMB = new BigDecimal((double)used / 1024.0 / 1024.0);
        usedMB = usedMB.setScale(1, 4);
        this.statusMessage_d.setMessage(usedMB + "Mb " + CoreMsg.OF.getString() + " " + totalMB + "Mb");
    }
}

