/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.selection;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;

public class DefaultSelectionProvider
implements SelectionProvider {
    private List<SelectionListener> listeners;
    private Selection selection = DefaultSelection.EMPTY;

    public DefaultSelectionProvider() {
        this.listeners = new CopyOnWriteArrayList<SelectionListener>();
    }

    @Override
    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public void setSelection(Selection selection) {
        this.selection = selection;
        for (SelectionListener listener : this.listeners) {
            listener.selectionChanged(selection);
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }
}

