/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import java.text.BreakIterator;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.text.TextField;

class TrimmedTextField
extends TextField {
    private String fullText;
    private static final String TAIL = "...";

    public TrimmedTextField(UiContainer parent) {
        super(parent);
        super.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    TrimmedTextField.this.setText(TrimmedTextField.this.getFullText() + e.getKeyChar());
                }
            }
        });
    }

    @Override
    public void setText(String string) {
        this.setFullText(string);
        this.refactorText();
    }

    public String getFullText() {
        return this.fullText;
    }

    public void refactorText() {
        if (!this.isVisible()) {
            return;
        }
        String string = this.getFullText();
        if (string != null && !string.trim().equals("")) {
            String result = string;
            int fieldWith = this.getWidth();
            int textWidth = this.getFontMetrics(this.getFont()).stringWidth(string);
            if (textWidth > fieldWith) {
                BreakIterator wordIter = BreakIterator.getWordInstance();
                wordIter.setText(string);
                int end = wordIter.last();
                int start = wordIter.previous();
                while (start != -1 && textWidth > fieldWith) {
                    result = string.substring(0, end) + TAIL;
                    textWidth = this.getFontMetrics(this.getFont()).stringWidth(result);
                    end = start;
                    start = wordIter.previous();
                }
            }
            super.setText(result);
        }
    }

    private void setFullText(String fullText) {
        this.fullText = fullText;
    }
}

