/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.utils.Layout;

public abstract class DialogPropertyEditor
extends AbstractEditor {
    @Override
    public Object getCellEditorValue() {
        return this.getProperty().getValue();
    }

    @Override
    public UiComponent getEditor(UiContainer parent) {
        return this.createEditor(parent);
    }

    protected abstract void openDialog(UiContainer var1, Property var2);

    protected abstract String getRenderer(Property var1);

    private Panel createEditor(UiContainer parent) {
        final Panel mainPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout(layout);
        mainPanel.setOpaque(false);
        mainPanel.setBorder(null);
        Label label = Label.create(mainPanel);
        label.setBorder(null);
        label.setOpaque(false);
        Button triggerButton = new Button(mainPanel);
        triggerButton.setAction(new BaseAction(UIMsg.TO_MSG("...")){

            @Override
            public void run() {
                DialogPropertyEditor.this.openDialog(mainPanel, DialogPropertyEditor.this.getProperty());
                DialogPropertyEditor.this.stopCellEditing();
            }
        });
        triggerButton.setDefaultCapable(false);
        triggerButton.setFocusPainted(false);
        mainPanel.add(label, "field");
        mainPanel.add(triggerButton, "button");
        this.layoutComponents(layout);
        label.setText(this.getRenderer(this.getProperty()));
        return mainPanel;
    }

    private void layoutComponents(RelativeLayout layout) {
        Layout.fixToRoot(layout, "button", AttributeType.RIGHT);
        Layout.fixToRoot(layout, "button", AttributeType.TOP);
        Layout.fixToRoot(layout, "button", AttributeType.BOTTOM);
        layout.addConstraint("button", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.HEIGHT));
        layout.addConstraint("field", AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT, -1));
        Layout.fixToComp(layout, "field", AttributeType.VERTICAL_CENTER, "button");
        Layout.fixToRoot(layout, "field", AttributeType.LEFT, 1);
    }
}

