/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import java.util.ArrayList;
import java.util.Vector;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.ComboValueProvider;

public class ComboPropertyEditor
extends AbstractEditor {
    private ComboBox editor;
    private LabelProvider provider;

    @Override
    public Object getCellEditorValue() {
        Object value = this.editor.getSelectedItem();
        ComboValueProvider valueProvider = (ComboValueProvider)((Object)this.getProperty());
        if (valueProvider.isAllowNullValues() && this.editor.getSelectedIndex() == 0) {
            value = Property.NULL_VALUE;
        }
        return value;
    }

    @Override
    public UiComponent getEditor(UiContainer parent) {
        this.editor = this.createEditor(parent);
        return this.editor;
    }

    public void setLabelProvider(LabelProvider provider) {
        this.provider = provider;
    }

    private ComboBox createEditor(UiContainer parent) {
        ComboBox<String> editor = UiFactory.createMutableComboBox(parent, new ArrayList());
        editor.putClientProperty("ComboBox.isTableCellEditor", Boolean.TRUE);
        editor.setBorder(null);
        Property property = this.getProperty();
        ComboValueProvider valueProvider = (ComboValueProvider)((Object)this.getProperty());
        Vector values = valueProvider.getValues();
        if (valueProvider.isAllowNullValues()) {
            editor.addItem("");
        }
        for (int i = 0; i < values.size(); ++i) {
            Object item = values.elementAt(i);
            editor.addItem((String)item);
        }
        if (valueProvider.isAllowNullValues() && (property.getValue() == null || property.getValue().equals(Property.NULL_VALUE))) {
            editor.setSelectedIndex(0);
        } else {
            editor.setSelectedItem(property.getValue());
        }
        editor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ComboPropertyEditor.this.stopCellEditing();
                }
            }
        });
        if (this.provider != null) {
            editor.setLabelProvider(this.provider);
        }
        return editor;
    }
}

