/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.draw.Color;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class ColorPropertyEditor
extends AbstractEditor {
    private Editor editor;

    @Override
    public Object getCellEditorValue() {
        return this.editor.getColor();
    }

    @Override
    public UiComponent getEditor(UiContainer parent) {
        this.editor = this.createEditor(parent);
        return this.editor;
    }

    private Editor createEditor(UiContainer parent) {
        return new Editor(parent);
    }

    private class Editor
    extends Panel {
        private Color color;
        private ColorChoosingComponent colorChooser;

        Editor(UiContainer parent) {
            super(parent);
            this.init();
        }

        public Color getColor() {
            return this.colorChooser.getSelectedColor();
        }

        public void init() {
            Object value = ColorPropertyEditor.this.getProperty().getValue();
            Color currentColor = value != Property.NULL_VALUE ? (Color)value : Color.WHITE;
            this.colorChooser = new ColorChoosingComponent(this, UIMsg.TO_MSG(""), currentColor, true, true, false);
            BorderLayout layout = new BorderLayout();
            this.setLayout(layout);
            this.setOpaque(false);
            this.setBorder(null);
            this.add(this.colorChooser, "North");
        }
    }
}

