/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.ResetableProperty;
import oracle.bpm.ui.prop.impl.ColorPropertyEditor;

public class ColorProperty
extends AbstractProperty
implements ResetableProperty {
    static Color defaultColor = Color.WHITE;

    public ColorProperty(Msg key, Color defaultColor) {
        this.setKey(key);
        this.setValue(defaultColor == null ? NULL_VALUE : defaultColor);
        ColorPropertyRenderer renderer = new ColorPropertyRenderer();
        ColorPropertyEditor editor = new ColorPropertyEditor();
        this.setPropertyRenderer(renderer);
        this.setPropertyEditor(editor);
    }

    @Override
    public Object getDefaultValue() {
        return NULL_VALUE;
    }

    private static class ColorPropertyRenderer
    implements PropertyRenderer {
        private ColorPropertyRenderer() {
        }

        @Override
        public String getRenderer(Property property) {
            return this.renderProperty(property);
        }

        @Override
        public String getToolTip(Property property) {
            return this.renderProperty(property);
        }

        private String renderProperty(Property property) {
            String result;
            Object value = property.getValue();
            if (value != Property.NULL_VALUE) {
                Color color = (Color)value;
                result = "[ r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + " ]";
            } else {
                result = UIMsg.PROPERTY_NO_COLOR.getString();
            }
            return result;
        }
    }
}

