/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop.impl;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.BorderTypeComboBox;

public class BorderTypeProperty
extends AbstractProperty {
    public BorderTypeProperty(Msg key, BorderStyle borderStyle) {
        this(key.getString(), borderStyle);
    }

    public BorderTypeProperty(String key, BorderStyle borderStyle) {
        this.setKey(key);
        this.setValue(borderStyle);
        this.setPropertyRenderer(new BorderTypePropertyRenderer());
        this.setPropertyEditor(new BorderTypePropertyEditor());
    }

    private static class BorderTypePropertyRenderer
    implements PropertyRenderer {
        private BorderTypePropertyRenderer() {
        }

        @Override
        public String getRenderer(Property property) {
            return BorderTypePropertyRenderer.renderProperty(property);
        }

        @Override
        public String getToolTip(Property property) {
            return BorderTypePropertyRenderer.renderProperty(property);
        }

        private static String renderProperty(Property property) {
            return property != null ? property.getValue().toString() : null;
        }
    }

    private static class BorderTypePropertyEditor
    extends AbstractEditor {
        private BorderTypeComboBox editor;

        private BorderTypePropertyEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getSelectedItem();
        }

        @Override
        public UiComponent getEditor(UiContainer parent) {
            this.editor = this.createEditor(parent);
            this.editor.setSelectedItem(this.getProperty().getValue());
            return this.editor;
        }

        private BorderTypeComboBox createEditor(UiContainer parent) {
            BorderTypeComboBox editor = new BorderTypeComboBox(parent);
            editor.setBorder(null);
            editor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        BorderTypePropertyEditor.this.stopCellEditing();
                    }
                }
            });
            return editor;
        }
    }
}

