/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.FocusTraversableAdapter;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.VisibilityAdapter;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyTablePanel;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;

public class PropertyTable
extends Panel
implements SelectionListener {
    private boolean editable = true;
    private FocusTraversable focusTraversableManager;
    private SelectionProvider selectionProvider;
    private boolean showGroupsAsPanels = true;

    public PropertyTable(UiContainer parent, SelectionProvider selectionProvider) {
        super(parent);
        this.selectionProvider = selectionProvider;
        this.addVisibilityListener(new VisibilityAdapter(){

            @Override
            public void onDispose() {
                PropertyTable.this.onDispose();
            }
        });
        this.onVisible();
    }

    @Override
    public void selectionChanged(Selection newSelection) {
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public PropertyTablePanel addPropertyTablePanel(Msg name) {
        return this.addPropertyTablePanel(name, true);
    }

    public PropertyTablePanel addPropertyTablePanel(Msg name, boolean isExpanded) {
        PropertyTablePanel tablePanel = new PropertyTablePanel(this, name, isExpanded);
        this.addPropertyTablePanel(tablePanel);
        return tablePanel;
    }

    public void addPropertyTablePanel(PropertyTablePanel tablePanel) {
        tablePanel.setEditable(this.isEditable());
        this.getTablePanelList().add(tablePanel);
        PropertyTablePanel.TitlePanel titlePanel = tablePanel.getTitlePanel();
        this.add(titlePanel, "wrap, growx, top");
        this.add(tablePanel, "wrap, grow");
    }

    public void stopEditing() {
        List<PropertyTablePanel> tablePanelList = this.getTablePanelList();
        for (PropertyTablePanel propertyTablePanel : tablePanelList) {
            propertyTablePanel.stopCellEditing();
        }
    }

    public void build() {
        List<PropertyTablePanel> tablePanelList = this.getTablePanelList();
        for (PropertyTablePanel propertyTablePanel : tablePanelList) {
            propertyTablePanel.stopCellEditing();
            propertyTablePanel.reload();
        }
        if (tablePanelList.size() > 0) {
            this.revalidate();
        }
    }

    public void clearAll() {
        this.removeAll();
        this.repaint();
    }

    @Override
    public MigLayout getLayout() {
        return (MigLayout)super.getLayout();
    }

    public void refreshAll() {
        List<PropertyTablePanel> tablePanelList = this.getTablePanelList();
        for (PropertyTablePanel tablePanel : tablePanelList) {
            this.refresh(tablePanel);
        }
    }

    public void refresh(Property property) {
        List<PropertyTablePanel> tablePanelList = this.getTablePanelList();
        for (PropertyTablePanel tablePanel : tablePanelList) {
            this.refresh(tablePanel, property);
        }
    }

    public FocusTraversable getFocusTraversableManager() {
        return this.focusTraversableManager;
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public boolean isShowGroupsAsPanels() {
        return this.showGroupsAsPanels;
    }

    public void setShowGroupsAsPanels(boolean showGroupsAsPanels) {
        this.showGroupsAsPanels = showGroupsAsPanels;
    }

    protected void onVisible() {
        this.initUi();
        this.selectionChanged(this.selectionProvider.getSelection());
        this.selectionProvider.addSelectionListener(this);
    }

    @Override
    protected void onDispose() {
        this.selectionProvider.removeSelectionListener(this);
    }

    protected void initUi() {
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.focusTraversableManager = new FocusTraversableAdapter(){

            @Override
            public UiComponent getDefaultComponent() {
                return null;
            }

            @Override
            public UiComponent getFirstComponent() {
                List tablePanelList = PropertyTable.this.getTablePanelList();
                return tablePanelList.size() > 0 ? (Panel)tablePanelList.get(0) : PropertyTable.this;
            }

            @Override
            public boolean accept(UiComponent component) {
                return super.accept(component) && component != PropertyTable.this;
            }
        };
        this.setEditable(true);
        MigLayout layout = new MigLayout("hidemode 3, gap 0, ins 0, fill");
        this.setLayout(layout);
    }

    private void refresh(PropertyTablePanel panel) {
        for (Property property : panel.getGroup().getChildren()) {
            panel.reloadProperty((AbstractProperty)property);
        }
    }

    private void refresh(PropertyTablePanel panel, Property property) {
        panel.reloadProperty((AbstractProperty)property);
    }

    private List<PropertyTablePanel> getTablePanelList() {
        ArrayList<PropertyTablePanel> result = new ArrayList<PropertyTablePanel>();
        for (UiComponent component : this.getChildren()) {
            if (!(component instanceof PropertyTablePanel)) continue;
            result.add((PropertyTablePanel)component);
        }
        return result;
    }
}

