/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import java.util.LinkedList;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.tree.AbstractTreeTableModel;

public class PropertyModel
extends AbstractTreeTableModel {
    private boolean editable;
    private static final String[] COLUMNS = new String[]{"Key", "Value"};
    private static final Class[] CLASSES = new Class[]{String.class, Property.class};

    public PropertyModel() {
        super(new PropertyGroup("ROOT"));
        this.setEditable(true);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (column == 1) {
            assert (node != null) : "Property cannot be null.";
            Property property = (Property)node;
            return this.isEditable() && property.isEditable();
        }
        return false;
    }

    @Override
    public Object getChild(Object parent, int index) {
        PropertyGroup group = (PropertyGroup)parent;
        return group.get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof PropertyGroup) {
            int count = ((PropertyGroup)parent).getCount();
            return count;
        }
        return 0;
    }

    @Override
    public Class getColumnClass(int column) {
        return CLASSES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public Object getParent(Object node) {
        AbstractProperty result = null;
        if (node instanceof PropertyGroup) {
            PropertyGroup group = (PropertyGroup)node;
            result = group.getParent();
        }
        return result;
    }

    public AbstractProperty[] getPathFor(AbstractProperty node) {
        AbstractProperty property = (AbstractProperty)this.findNode((Property)this.root, node);
        if (property == null) {
            return new AbstractProperty[0];
        }
        LinkedList<AbstractProperty> properties = new LinkedList<AbstractProperty>();
        properties.add(property);
        for (AbstractProperty parent = property.getParent(); parent != null; parent = parent.getParent()) {
            properties.addFirst(parent);
        }
        return properties.toArray(new AbstractProperty[properties.size()]);
    }

    public AbstractProperty[] getPathToRoot(AbstractProperty aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    @Override
    public void setValueAt(Object newValue, Object node, int column) {
        if (column == 1) {
            Property property = (Property)node;
            property.updateValue(newValue);
        }
    }

    @Override
    public Object getValueAt(Object node, int column) {
        Property property = (Property)node;
        switch (column) {
            case 0: {
                Msg msg = property.getMsg();
                return msg != null ? msg.getString() : property.getKey();
            }
        }
        if (property instanceof BooleanProperty) {
            return property.getValue();
        }
        return property;
    }

    public void reload() {
        this.reload((AbstractProperty)this.root);
    }

    public void reload(AbstractProperty node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void reloadNode(AbstractProperty node) {
        if (node != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected AbstractProperty[] getPathToRoot(AbstractProperty aNode, int depth) {
        AbstractProperty[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new AbstractProperty[depth];
        } else {
            retNodes = aNode == this.root ? new AbstractProperty[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    private Property findNode(Property current, AbstractProperty node) {
        if (current == node) {
            return current;
        }
        if (current instanceof PropertyGroup) {
            PropertyGroup group = (PropertyGroup)current;
            for (int i = 0; i < group.getCount(); ++i) {
                Property found = this.findNode(group.get(i), node);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

