/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.TreeExpansionEvent;
import oracle.bpm.ui.event.TreeExpansionListener;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyModel;
import oracle.bpm.ui.treetable.TreeTableProperty;

public class PropertyList
extends TreeTableProperty {
    private PropertyModel propertyModel;

    public PropertyList(UiContainer parent, PropertyModel propertyModel) {
        super(parent, propertyModel);
        this.setPropertyModel(propertyModel);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Property property;
                Object selectedItem = event.getPath().getLastPathComponent();
                if (selectedItem != null && (property = (Property)selectedItem) instanceof PropertyGroup) {
                    ((PropertyGroup)property).propertyCollapsed();
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Property property;
                Object selectedItem = event.getPath().getLastPathComponent();
                if (selectedItem != null && (property = (Property)selectedItem) instanceof PropertyGroup) {
                    ((PropertyGroup)property).propertyExpanded();
                }
            }
        });
    }

    public void setEditable(boolean editable) {
        this.propertyModel.setEditable(editable);
    }

    public boolean isEditable() {
        return this.propertyModel.isEditable();
    }

    public PropertyModel getPropertyModel() {
        return this.propertyModel;
    }

    public Property getSelectedProperty() {
        Object selectedItem = this.getLastSelectedPathComponent();
        return selectedItem != null ? (Property)selectedItem : null;
    }

    public void reloadProperty(AbstractProperty property) {
        PropertyModel model = this.getPropertyModel();
        model.reloadNode(property);
    }

    private void setPropertyModel(PropertyModel propertyModel) {
        this.propertyModel = propertyModel;
    }
}

