/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.prop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyEditor;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyRenderer;
import oracle.bpm.ui.prop.impl.AbstractEditor;

public class CompositeProperty
extends PropertyGroup {
    private Property basicProperty;
    private boolean isGroup = false;
    private List<Property> properties = new ArrayList<Property>();
    private boolean sameValues = true;
    private Object value = null;
    private static CompositePropertyEditor compositePropertyEditor;
    private static CompositePropertyRenderer compositePropertyRenderer;

    public CompositeProperty(Property basicProperty) {
        super(basicProperty);
        this.basicProperty = basicProperty;
        this.properties.add(basicProperty);
        this.value = basicProperty.getValue();
        this.isGroup = basicProperty instanceof PropertyGroup && !basicProperty.isEditable();
        this.setEditable(basicProperty.isEditable());
        this.setPropertyEditor(CompositeProperty.getCompositePropertyEditor());
        this.setPropertyRenderer(CompositeProperty.getCompositePropertyRenderer());
        if (this.isGroup) {
            this.initGroup();
        }
    }

    @Override
    public String getKey() {
        return this.basicProperty.getKey();
    }

    @Override
    public void setValue(Object newValue) {
        this.value = newValue;
        this.recalculateChilds();
        if (this.properties != null) {
            Iterator<Property> it = this.properties.iterator();
            this.sameValues = true;
            while (it.hasNext()) {
                it.next().setValue(newValue);
            }
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void add(Property property) {
        this.compose(property);
    }

    public void compose(Property property) {
        this.properties.add(property);
        if (this.value == null && property.getValue() != null || this.value != null && !this.value.equals(property.getValue())) {
            this.value = null;
            this.sameValues = false;
        }
        if (this.isGroup) {
            this.addGroup(property);
            property.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CompositeProperty.this.recalculate();
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.basicProperty instanceof PropertyGroup) {
            for (PropertyGroup propertyGroup : this.properties) {
                propertyGroup.propertyChange(evt);
            }
        }
    }

    @Override
    protected void firePropertyChanged(PropertyChangeEvent event) {
        super.firePropertyChanged(event);
        if (this.isGroup) {
            this.recalculate();
        } else {
            if (event.getPropertyName().equals(this.basicProperty.getKey())) {
                this.value = event.getNewValue();
                this.sameValues = true;
                this.recalculateChilds();
            }
            for (AbstractProperty abstractProperty : this.properties) {
                abstractProperty.firePropertyChanged(event);
            }
        }
    }

    protected void recalculate() {
        Object value = this.basicProperty.getValue();
        Iterator<Property> it = this.properties.iterator();
        this.sameValues = true;
        while (it.hasNext()) {
            Object nextValue = it.next().getValue();
            if ((value != null || nextValue == null) && (value == null || value.equals(nextValue))) continue;
            this.sameValues = false;
            break;
        }
        if (this.sameValues) {
            this.value = value;
        }
    }

    private static PropertyEditor getCompositePropertyEditor() {
        if (compositePropertyEditor == null) {
            compositePropertyEditor = new CompositePropertyEditor();
        }
        return compositePropertyEditor;
    }

    private static PropertyRenderer getCompositePropertyRenderer() {
        if (compositePropertyRenderer == null) {
            compositePropertyRenderer = new CompositePropertyRenderer();
        }
        return compositePropertyRenderer;
    }

    private static Property getProperty(Property property) {
        if (property instanceof CompositeProperty) {
            property = ((CompositeProperty)property).basicProperty;
        }
        return property;
    }

    private void addGroup(Property p) {
        PropertyGroup group = (PropertyGroup)p;
        int count = group.getCount();
        for (int i = 0; i < count; ++i) {
            CompositeProperty composite = (CompositeProperty)super.get(i);
            composite.compose(group.get(i));
        }
    }

    private void initGroup() {
        PropertyGroup group = (PropertyGroup)this.basicProperty;
        int count = group.getCount();
        for (int i = 0; i < count; ++i) {
            super.add(new CompositeProperty(group.get(i)));
        }
    }

    private void recalculateChilds() {
    }

    private static class CompositePropertyRenderer
    implements PropertyRenderer {
        private CompositePropertyRenderer() {
        }

        @Override
        public String getRenderer(Property property) {
            return CompositePropertyRenderer.renderProperty(property);
        }

        @Override
        public String getToolTip(Property property) {
            return CompositePropertyRenderer.renderProperty(property);
        }

        private static boolean isDifferentValues(Property property) {
            return property instanceof CompositeProperty && !((CompositeProperty)property).sameValues;
        }

        private static String renderProperty(Property property) {
            if (CompositePropertyRenderer.isDifferentValues(property)) {
                return UIMsg.DIFFERENT_PROPERTY_VALUES.getString();
            }
            Property innerProperty = CompositeProperty.getProperty(property);
            PropertyRenderer realRender = innerProperty.getPropertyRenderer();
            return realRender.getRenderer(innerProperty);
        }
    }

    private static class CompositePropertyEditor
    extends AbstractEditor {
        private CompositePropertyEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            Property realProperty = CompositeProperty.getProperty(this.getProperty());
            PropertyEditor realEditor = realProperty.getPropertyEditor();
            return realEditor.getCellEditorValue();
        }

        @Override
        public UiComponent getEditor(UiContainer parent) {
            Property property = CompositeProperty.getProperty(this.getProperty());
            PropertyEditor realEditor = property.getPropertyEditor();
            return realEditor.createEditor(parent, property);
        }

        @Override
        public void cancelCellEditing() {
            Property realProperty = CompositeProperty.getProperty(this.getProperty());
            PropertyEditor realEditor = realProperty.getPropertyEditor();
            realEditor.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            Property realProperty = CompositeProperty.getProperty(this.getProperty());
            PropertyEditor realEditor = realProperty.getPropertyEditor();
            return realEditor.stopCellEditing();
        }
    }
}

