/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.plaf.fuego;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.peer.swing.AwtConverter;

final class FuegoSplitPaneDividerUI
extends BasicSplitPaneDivider {
    static final long serialVersionUID = 4642873420922807957L;
    static final long serialCheck = 7266396287933505416L;

    public FuegoSplitPaneDividerUI(BasicSplitPaneUI paneUI) {
        super(paneUI);
        this.setLayout(new LayoutManager(){
            private final FuegoSplitPaneDividerUI divider;
            {
                this.divider = FuegoSplitPaneDividerUI.this;
            }

            @Override
            public void layoutContainer(Container container) {
                JButton leftButton = FuegoSplitPaneDividerUI.this.getLeftButton();
                JButton rightButton = FuegoSplitPaneDividerUI.this.getRightButton();
                JSplitPane splitPane = FuegoSplitPaneDividerUI.this.getSplitPane();
                int orientation = FuegoSplitPaneDividerUI.this.getOrientation();
                int size = FuegoSplitPaneDividerUI.this.getOneTouchSize();
                int offset = FuegoSplitPaneDividerUI.this.getOneTouchOffset();
                int blockSize = 5;
                if (leftButton != null && rightButton != null && container == this.divider) {
                    if (splitPane.isOneTouchExpandable()) {
                        if (orientation == 0) {
                            leftButton.setBounds(offset, 0, 10, 5);
                            rightButton.setBounds(offset + size * 2, 0, 10, 5);
                        } else {
                            leftButton.setBounds(0, offset, 5, 10);
                            rightButton.setBounds(0, offset + size * 2, 5, 10);
                        }
                    } else {
                        leftButton.setBounds(-5, -5, 1, 1);
                        rightButton.setBounds(-5, -5, 1, 1);
                    }
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return AwtConverter.toAwt(oracle.bpm.geom.Dimension.ZERO);
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return AwtConverter.toAwt(oracle.bpm.geom.Dimension.ZERO);
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public void addLayoutComponent(String string, Component component) {
            }
        });
    }

    @Override
    public javax.swing.border.Border getBorder() {
        return null;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        LeftOneTouchButton button = new LeftOneTouchButton(null);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        return (JButton)button.asSwing();
    }

    @Override
    protected JButton createRightOneTouchButton() {
        RightOneTouchButton button = new RightOneTouchButton();
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        return (JButton)button.asSwing();
    }

    JButton getLeftButton() {
        return this.leftButton;
    }

    int getOneTouchOffset() {
        return 2;
    }

    int getOneTouchSize() {
        return 5;
    }

    int getOrientation() {
        return this.orientation;
    }

    JButton getRightButton() {
        return this.rightButton;
    }

    JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private static Color[] colors(Color background) {
        return new Color[]{background, UiManager.color("controlDkShadow"), Color.BLACK, UiManager.color("controlLtHighlight")};
    }

    private final class RightOneTouchButton
    extends Button {
        int[][] pixels;

        public RightOneTouchButton() {
            super((UiContainer)null);
            this.pixels = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};
            this.setBackground(UiManager.color("SplitPane.background"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            block7: {
                JSplitPane splitpane = FuegoSplitPaneDividerUI.this.getSplitPane();
                if (splitpane == null) break block7;
                int orientation = FuegoSplitPaneDividerUI.this.getOrientation();
                int size = this.pixels.length + 1;
                Color background = this.getBackground();
                Color[] colors = FuegoSplitPaneDividerUI.colors(background);
                graphics.setForeground(background);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isPressed()) {
                    colors[1] = colors[2];
                }
                if (orientation == 0) {
                    for (int j = 1; j <= this.pixels[0].length; ++j) {
                        for (int k = 1; k < size; ++k) {
                            if (this.pixels[k - 1][j - 1] == 0) continue;
                            graphics.setForeground(colors[this.pixels[k - 1][j - 1]]);
                            graphics.drawLine(j, k, j, k);
                        }
                    }
                } else {
                    for (int j = 1; j <= this.pixels[0].length; ++j) {
                        for (int k = 1; k < size; ++k) {
                            if (this.pixels[k - 1][j - 1] == 0) continue;
                            graphics.setForeground(colors[this.pixels[k - 1][j - 1]]);
                            graphics.drawLine(k - 1, j, k - 1, j);
                        }
                    }
                }
            }
        }
    }

    private final class LeftOneTouchButton
    extends Button {
        int[][] pixels;

        public LeftOneTouchButton(UiContainer parent) {
            super(parent);
            this.pixels = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};
            this.setBackground(UiManager.color("SplitPane.background"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            block7: {
                JSplitPane splitpane = FuegoSplitPaneDividerUI.this.getSplitPane();
                if (splitpane == null) break block7;
                int orientation = FuegoSplitPaneDividerUI.this.getOrientation();
                int size = this.pixels.length + 1;
                Color background = this.getBackground();
                Color[] colors = FuegoSplitPaneDividerUI.colors(background);
                graphics.setForeground(background);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isPressed()) {
                    colors[1] = colors[2];
                }
                if (orientation == 0) {
                    for (int j = 1; j <= this.pixels[0].length; ++j) {
                        for (int k = 1; k < size; ++k) {
                            if (this.pixels[k - 1][j - 1] == 0) continue;
                            graphics.setForeground(colors[this.pixels[k - 1][j - 1]]);
                            graphics.drawLine(j - 1, k, j - 1, k);
                        }
                    }
                } else {
                    for (int j = 1; j <= this.pixels[0].length; ++j) {
                        for (int k = 1; k < size; ++k) {
                            if (this.pixels[k - 1][j - 1] == 0) continue;
                            graphics.setForeground(colors[this.pixels[k - 1][j - 1]]);
                            graphics.drawLine(k - 1, j, k - 1, j);
                        }
                    }
                }
            }
        }
    }
}

