/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.plaf.fuego;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.plaf.fuego.FuegoArrowButton;

public final class FuegoComboBoxUI
extends BasicComboBoxUI {
    private static final JTextField phantomTextField = new JTextField("Phantom");

    public static ComponentUI createUI(JComponent c) {
        return new FuegoComboBoxUI();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension minimumSize = this.getMinimumSize(c);
        Dimension maximumSize = super.getMaximumSize(c);
        maximumSize.height = minimumSize.height;
        maximumSize.width = Math.max(maximumSize.width, minimumSize.height);
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension componentDim = super.getMinimumSize(c);
        Dimension textFieldDim = new Dimension(FuegoComboBoxUI.phantomTextField.getMinimumSize().width, FuegoComboBoxUI.phantomTextField.getMinimumSize().height);
        int width = componentDim.width;
        int height = textFieldDim.height;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    protected JButton createArrowButton() {
        return new FuegoArrowButton(5);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    @Override
    protected void installDefaults() {
        UIDefaults uiDefaults = UIManager.getDefaults();
        if (uiDefaults.getBorder("ComboBox.border") == null) {
            Border border = BorderFactory.createLineBorder(UiManager.color("ComboBox.buttonDarkShadow"), 1);
            BorderUIResource borderUI = new BorderUIResource(border.asSwing());
            uiDefaults.put("ComboBox.border", borderUI);
        }
        super.installDefaults();
    }

    private class ComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private ComboBoxLayoutManager() {
            super(FuegoComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jcombobox = (JComboBox)container;
            int comboWidth = jcombobox.getWidth();
            int comboHeight = jcombobox.getHeight();
            Insets insets = AwtConverter.fromAwt(FuegoComboBoxUI.this.getInsets());
            int scrollWidth = UIManager.getInt("ScrollBar.width");
            int height = comboHeight - (insets.top + insets.bottom);
            if (FuegoComboBoxUI.this.arrowButton != null) {
                if (jcombobox.getComponentOrientation().isLeftToRight()) {
                    FuegoComboBoxUI.this.arrowButton.setBounds(comboWidth - (insets.right + scrollWidth), insets.top, scrollWidth, height);
                } else {
                    FuegoComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, scrollWidth, height);
                }
            }
            if (FuegoComboBoxUI.this.editor != null) {
                FuegoComboBoxUI.this.editor.setBounds(FuegoComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

