/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JDialog;
import oracle.bpm.ui.peer.swing.interval.Spinner;
import oracle.bpm.ui.peer.swing.interval.SpinnerGUI;
import oracle.bpm.ui.peer.swing.interval.SubField;
import oracle.bpm.ui.peer.swing.interval.TimeFieldGUI;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

public abstract class TimeIntervalField
extends Spinner
implements Serializable {
    protected Object default_d;
    protected TimeField.Format format;
    protected Format format_d;
    protected String formatString_d;
    protected Locale locale_d;
    protected String text_d;
    private int currentFieldNum_d;
    private transient TimeFieldGUI gui_d;
    private boolean required_d = true;
    private SubField[] subFormats_d;

    TimeIntervalField(TimeField.Format format, String pattern, Locale locale) {
        this.format = format;
        this.formatString_d = pattern;
        this.locale_d = locale;
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public void setDefault(Object defaultValue) {
        this.default_d = defaultValue;
    }

    public Object getDefault() {
        return this.default_d;
    }

    public void setDialog(JDialog d) {
        if (this.gui_d != null) {
            this.gui_d.setDialog(d);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.gui_d.enableCalendar(enable);
        super.setEnabled(enable);
    }

    public Format getFormat() {
        if (this.format_d == null) {
            this.init();
        }
        return this.format_d;
    }

    public String getFormatString() {
        return this.formatString_d;
    }

    @Override
    public Locale getLocale() {
        return this.locale_d;
    }

    public void setRequired(boolean v) {
        this.required_d = v;
        if (this.required_d && this.text_d.equals("")) {
            this.setValue(this.getDefault());
        }
    }

    public boolean isRequired() {
        return this.required_d;
    }

    public void setSpinnerRepeatEnabled(boolean enabled) {
        if (this.gui_d != null) {
            this.gui_d.setTimerEnabled(enabled);
        }
    }

    public void setText(String text) {
        String prev = this.text_d;
        if (text == null || text.equals("")) {
            if (!this.isRequired()) {
                this.setValue(null);
                this.firePropertyChange("text", prev, this.text_d);
            }
        } else {
            Object value = this.parse(text);
            if (value != null) {
                this.setValue(value);
                this.firePropertyChange("text", prev, this.text_d);
            }
        }
    }

    public String getText() {
        return this.text_d;
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (this.getGUI() != null) {
            ((TimeFieldGUI)this.getGUI()).addFocusListener(fl);
        }
    }

    public synchronized void addValueChangedListener(ValueChangedListener listener) {
        this.listenerList.add(ValueChangedListener.class, listener);
    }

    public void advanceField(int i) {
        int fld = this.getFieldNum(this.getCaretPos());
        if (i > 0) {
            while (i > 0 && fld < this.subFormats_d.length - 1) {
                if (!this.subFormats_d[++fld].isFormat()) continue;
                --i;
            }
        } else {
            while (i < 0 && fld > 0) {
                if (!this.subFormats_d[--fld].isFormat()) continue;
                ++i;
            }
        }
        this.currentFieldNum_d = fld;
        this.setCaretPos(this.getFieldStart());
    }

    public synchronized void removeValueChangedListener(ValueChangedListener listener) {
        this.listenerList.remove(ValueChangedListener.class, listener);
    }

    @Override
    public void scrollUp() {
        this.scroll(this.getCaretPos(), true);
    }

    protected abstract Format buildFormat(String var1);

    protected abstract Object parse(String var1);

    protected abstract boolean rollField(String var1, boolean var2);

    protected void init() {
        this.findSubFormats();
        this.findParsePositions();
        this.makeInputFormats();
        if (this.gui_d == null) {
            this.gui_d = new TimeFieldGUI(this);
        }
    }

    protected void makeInputFormats() {
    }

    protected void findParsePositions() {
        ParsePosition parseposition = new ParsePosition(0);
        for (int i = 0; i < this.subFormats_d.length; ++i) {
            SubField subfield = this.subFormats_d[i];
            if (!subfield.isFormat()) {
                parseposition.setIndex(parseposition.getIndex() + subfield.getCharCount());
            } else {
                try {
                    Format fmt = this.buildFormat(subfield.getSubFormat());
                    fmt.parseObject(this.text_d, parseposition);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    parseposition.setIndex(this.text_d.length());
                }
            }
            subfield.setParsePosition(new ParsePosition(parseposition.getIndex()));
        }
    }

    protected void findSubFormats() {
        ArrayList<SubField> formats = new ArrayList<SubField>();
        boolean insideQuotes = false;
        char lastChar = '\u0000';
        int len = 0;
        for (int i = 0; i < this.formatString_d.length(); ++i) {
            char chr = this.formatString_d.charAt(i);
            if (insideQuotes) {
                if (chr != '\'') {
                    ++len;
                    continue;
                }
                if (len == 0) {
                    formats.add(new SubField(false, '\'', 1, this.locale_d));
                } else {
                    formats.add(new SubField(false, lastChar, len, this.locale_d));
                }
                len = 0;
                insideQuotes = false;
                continue;
            }
            if (chr != lastChar && len > 0) {
                boolean formatField = lastChar >= 'a' && lastChar <= 'z' || lastChar >= 'A' && lastChar <= 'Z';
                formats.add(new SubField(formatField, lastChar, len, this.locale_d));
                len = 0;
            }
            if (chr == '\'') {
                insideQuotes = true;
                len = 0;
                lastChar = '\u0000';
                continue;
            }
            lastChar = chr;
            ++len;
        }
        if (len > 0) {
            boolean formatField = lastChar >= 'a' && lastChar <= 'z' || lastChar >= 'A' && lastChar <= 'Z';
            formats.add(new SubField(formatField, lastChar, len, this.locale_d));
        }
        this.subFormats_d = formats.toArray(new SubField[formats.size()]);
    }

    protected void fireValueChangedEvent() {
        ValueChangedEvent event = new ValueChangedEvent(this, 20000, this.getValue());
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ValueChangedListener.class) continue;
            ((ValueChangedListener)listeners[i + 1]).valueChanged(event);
        }
    }

    void setCaretPos(int i) {
        this.gui_d.setCaretPos(i);
    }

    int getCaretPos() {
        return this.gui_d.getCaretPos();
    }

    int getFieldEnd() {
        return this.subFormats_d[this.currentFieldNum_d].getParsePosition().getIndex();
    }

    int getFieldStart() {
        if (this.currentFieldNum_d == 0) {
            return 0;
        }
        return this.subFormats_d[this.currentFieldNum_d - 1].getParsePosition().getIndex();
    }

    @Override
    SpinnerGUI getGUI() {
        return this.gui_d;
    }

    TimeField.Style getType() {
        return null;
    }

    @Override
    void scrollDown() {
        this.scroll(this.getCaretPos(), false);
    }

    private int getFieldNum(int n) {
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < this.subFormats_d.length; ++i) {
            if (n > this.subFormats_d[i].getIndex()) continue;
            return i;
        }
        return this.subFormats_d.length - 1;
    }

    private void readObject(ObjectInputStream objectinputstream) throws ClassNotFoundException, IOException {
        objectinputstream.defaultReadObject();
        this.init();
    }

    private void scroll(int i, boolean flag) {
        this.currentFieldNum_d = this.getFieldNum(i);
        if (!this.scrollField(this.currentFieldNum_d, flag)) {
            this.currentFieldNum_d = this.getFieldNum(++i);
            this.scrollField(this.currentFieldNum_d, flag);
        }
    }

    private boolean scrollField(int i, boolean up) {
        if (this.getValue() == null) {
            return true;
        }
        if (!this.subFormats_d[i].isFormat()) {
            return false;
        }
        return this.rollField(this.subFormats_d[i].getSubFormat(), up);
    }

    private void writeObject(ObjectOutputStream objectoutputstream) throws IOException {
        objectoutputstream.defaultWriteObject();
    }
}

