/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.interval;

import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JPanel;
import oracle.bpm.ui.peer.swing.interval.SpinnerGUI;

abstract class Spinner
extends JPanel
implements Serializable {
    private int columns_d;
    protected static final int DEFAULT_COL = 15;

    public Spinner() {
        this(15);
    }

    public Spinner(int columns) {
        this.columns_d = columns;
    }

    public void setColumns(int i) {
        this.columns_d = i;
        if (this.getGUI() != null) {
            this.getGUI().setColumns(i);
        }
    }

    public int getColumns() {
        return this.columns_d;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getGUI().setTextFieldEnabled(enabled);
        this.getGUI().setIncrButtonEnabled(enabled);
        this.getGUI().setDecrButtonEnabled(enabled);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getGUI().getMaximumSize(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getGUI().getMinimumSize(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getGUI().getPreferredSize(this);
    }

    abstract SpinnerGUI getGUI();

    abstract void scrollDown();

    abstract void scrollUp();
}

