/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.event;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bpm.ui.event.UiListener;

public class SwingListener {
    private UiListener uiListener;
    private static Map listeners = new HashMap();

    public void setUiListener(UiListener uiListener) {
        this.uiListener = uiListener;
    }

    public UiListener getUiListener() {
        return this.uiListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SwingListener get(UiListener listener, Class implClass) {
        assert (listener != null) : "Listener cannot be null";
        SwingListener result = null;
        Map map = listeners;
        synchronized (map) {
            WeakHashMap<UiListener, SwingListener> listenersByClass = (WeakHashMap<UiListener, SwingListener>)listeners.get(implClass);
            if (listenersByClass == null) {
                listenersByClass = new WeakHashMap<UiListener, SwingListener>();
                listeners.put(implClass, listenersByClass);
            }
            if ((result = (SwingListener)listenersByClass.get(listener)) == null) {
                result = SwingListener.create(implClass, listener);
            }
            listenersByClass.put(listener, result);
        }
        return result;
    }

    private static SwingListener create(Class impl, UiListener listener) {
        SwingListener result = null;
        try {
            result = (SwingListener)impl.newInstance();
            result.setUiListener(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }
}

