/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.peer.AbstractPeer;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.DropTargetHandlerPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.dnd.SwingDndUtilities;

public class SwingDropTargetHandler
extends AbstractPeer
implements DropTargetHandlerPeer {
    @Override
    public void createDropTarget(ComponentPeer target) {
        Component component = ((SwingComponent)target).getInputTarget();
        new DropTarget(component, SwingDndUtilities.actionToSwing(this.getUiHandler().getActions()), new SwingDropTargetListener());
    }

    private DropTargetHandler getUiHandler() {
        return (DropTargetHandler)this.getClientProperty("oracle.bpm.ui.key");
    }

    private class SwingDropTargetListener
    implements DropTargetListener {
        private boolean canDrop;

        private SwingDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Object o;
            this.canDrop = false;
            Transferable t = dtde.getTransferable();
            DataFlavor df = this.getMoreAmbitious(t.getTransferDataFlavors());
            if (df != null && (o = this.getObjectFromTransferable(t, df)) != null) {
                DndAction dndAction = SwingDndUtilities.actionFromSwing(dtde.getDropAction());
                this.canDrop = SwingDropTargetHandler.this.getUiHandler().canDrop(o, SwingDndUtilities.typeFromSwing(df), AwtConverter.fromAwt(dtde.getLocation()), dndAction);
            }
            int dropAction = dtde.getDropAction();
            if (this.canDrop && this.actionSupported(dropAction)) {
                dtde.acceptDrag(dropAction);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            int dropAction = dtde.getDropAction();
            if (this.canDrop && this.actionSupported(dropAction)) {
                dtde.acceptDrag(dropAction);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Object o;
            Transferable t = dtde.getTransferable();
            DataFlavor df = this.getMoreAmbitious(t.getTransferDataFlavors());
            if (df != null && (o = this.getObjectFromTransferable(t, df)) != null) {
                DndAction dndAction = SwingDndUtilities.actionFromSwing(dtde.getDropAction());
                SwingDropTargetHandler.this.getUiHandler().drop(o, SwingDndUtilities.typeFromSwing(df), AwtConverter.fromAwt(dtde.getLocation()), dndAction);
                dtde.getDropTargetContext().dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }

        private boolean actionSupported(int action) {
            return (action & 0x40000003) != 0;
        }

        private Object getObjectFromTransferable(Transferable t, DataFlavor df) {
            try {
                Object o = t.getTransferData(df);
                Transfer transfer = SwingDndUtilities.typeFromSwing(df);
                return transfer == null ? null : transfer.dndToUi(o);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        private DataFlavor getMoreAmbitious(DataFlavor[] flavors) {
            Transfer[] type;
            for (Transfer aType : type = SwingDropTargetHandler.this.getUiHandler().getTransfers()) {
                for (DataFlavor flavor : flavors) {
                    Transfer transfer = SwingDndUtilities.typeFromSwing(flavor);
                    if (aType != transfer) continue;
                    return flavor;
                }
            }
            return null;
        }
    }
}

