/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.peer.AbstractPeer;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.DragSourceHandlerPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.dnd.SwingDndUtilities;
import oracle.bpm.ui.peer.swing.dnd.SwingDraggableComponent;

public class SwingDragSourceHandler
extends AbstractPeer
implements DragSourceHandlerPeer {
    @Override
    public void createDragSource(ComponentPeer source) {
        assert (source instanceof SwingDraggableComponent);
        SwingDraggableComponent draggable = (SwingDraggableComponent)((Object)source);
        JComponent jComponent = (JComponent)((SwingComponent)source).getInputTarget();
        draggable.setDragEnabled(true);
        jComponent.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                DndAction actions = SwingDragSourceHandler.this.getUiHandler().getActions();
                if (actions.isCopy()) {
                    return 1;
                }
                if (actions.isCopyOrMove()) {
                    return 3;
                }
                if (actions.isMove()) {
                    return 2;
                }
                return 0;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                if (SwingDragSourceHandler.this.getUiHandler().cancelDrag()) {
                    return null;
                }
                return new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return SwingDndUtilities.typesToSwing(SwingDragSourceHandler.this.getUiHandler().getTransfers());
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return SwingDragSourceHandler.this.getUiHandler().isDataTypeSupported(SwingDndUtilities.typeFromSwing(flavor));
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) {
                        Transfer type = SwingDndUtilities.typeFromSwing(flavor);
                        return type != null ? type.uiToDnd(SwingDragSourceHandler.this.getUiHandler().getObject(type)) : null;
                    }
                };
            }
        });
    }

    private DragSourceHandler getUiHandler() {
        return (DragSourceHandler)this.getClientProperty("oracle.bpm.ui.key");
    }
}

