/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing.dnd;

import java.awt.datatransfer.DataFlavor;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.FileTransfer;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.peer.swing.dnd.SwingLocalObjectTransfer;

public class SwingDndUtilities {
    private SwingDndUtilities() {
    }

    public static int actionToSwing(DndAction uiActions) {
        int result;
        switch (uiActions) {
            case COPY: {
                result = 1;
                break;
            }
            case COPY_OR_MOVE: {
                result = 3;
                break;
            }
            case MOVE: {
                result = 2;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public static DndAction actionFromSwing(int swingActions) {
        DndAction result;
        switch (swingActions) {
            case 1: {
                result = DndAction.COPY;
                break;
            }
            case 2: {
                result = DndAction.MOVE;
                break;
            }
            default: {
                result = DndAction.NONE;
            }
        }
        return result;
    }

    public static DataFlavor[] typesToSwing(Transfer[] t) {
        DataFlavor[] result = new DataFlavor[t.length];
        for (int i = 0; i < t.length; ++i) {
            result[i] = (DataFlavor)t[i].getNativeTransfer();
        }
        return result;
    }

    public static Transfer typeFromSwing(DataFlavor dataFlavor) {
        Transfer result = dataFlavor.equals(DataFlavor.javaFileListFlavor) ? FileTransfer.getInstance() : (dataFlavor instanceof SwingLocalObjectTransfer.DynamicDataFlavor ? LocalObjectTransfer.getInstance(dataFlavor.getRepresentationClass()) : (dataFlavor.equals(DataFlavor.stringFlavor) ? TextTransfer.getInstance() : null));
        return result;
    }
}

