/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import oracle.bpm.ui.ContentPane;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.Listener;
import oracle.bpm.ui.event.WindowListener;
import oracle.bpm.ui.peer.WindowPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.event.SwingWindowListener;

abstract class SwingWindow
extends SwingContainer
implements WindowPeer {
    private UiContainer contentPane;

    public SwingWindow(SwingComponent parent, Component component) {
        super(parent, component);
    }

    SwingWindow(SwingComponent parent) {
        this(parent, null);
    }

    @Override
    public UiComponent getFocusOwner() {
        Component focusOwner = this.getWindow().getFocusOwner();
        return UiComponent.get(focusOwner);
    }

    @Override
    public UiContainer getContentPane() {
        if (this.contentPane == null) {
            Container swingPane = this.getSwingContentPane();
            this.contentPane = new ContentPane((UiContainer)UiComponent.get(swingPane));
            this.contentPane.setParent(this.getUiContainer());
            swingPane.add(this.contentPane.asSwing());
        }
        return this.contentPane;
    }

    @Override
    public void setLocationRelativeTo(UiComponent component) {
        Component nativeComponent = component != null ? (Component)component.getNative() : null;
        this.getWindow().setLocationRelativeTo(nativeComponent);
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void setIconImage(Image image) {
        Window window = this.getWindow();
        if (image != null && window != null) {
            window.setIconImage(image.asAwtImage());
        }
    }

    @Override
    public Image getIconImage() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return Image.create(((Frame)window).getIconImage());
        }
        return null;
    }

    @Override
    public UiWindow getOwner() {
        Window owner = this.getWindow().getOwner();
        return this.getUiWindow(owner);
    }

    @Override
    public UiWindow[] getOwnerWindows() {
        Window[] ownedWindows = this.getWindow().getOwnedWindows();
        UiWindow[] windows = new UiWindow[ownedWindows.length];
        for (int i = 0; i < ownedWindows.length; ++i) {
            windows[i] = this.getUiWindow(ownedWindows[i]);
        }
        return windows;
    }

    @Override
    public void addWindowListener(WindowListener listener) {
        this.getWindow().addWindowListener(SwingWindowListener.get(listener));
    }

    @Override
    public void addListener(int type, Listener listener) {
    }

    @Override
    public void dispose() {
        this.getWindow().dispose();
    }

    @Override
    public void pack() {
        this.getWindow().pack();
    }

    @Override
    public void toFront() {
        this.getWindow().toFront();
    }

    protected abstract Container getSwingContentPane();

    protected UiWindow getUiWindow(Component component) {
        return (UiWindow)this.getUiComponent(component);
    }

    private Window getWindow() {
        return (Window)this.getComponent();
    }
}

