/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTableModel;

final class SwingTreeModelAdapter
implements TreeModel {
    private TreeTableModel treeTableModel;

    SwingTreeModelAdapter(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
    }

    @Override
    public Object getRoot() {
        return this.treeTableModel.getRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.treeTableModel.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.treeTableModel.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.treeTableModel.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeTableModel.addTreeModelListener(UiTreeModelListener.get(l));
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeTableModel.removeTreeModelListener(UiTreeModelListener.get(l));
    }

    public static class UiTreeModelListener
    extends RevertSwingListener
    implements oracle.bpm.ui.event.TreeModelListener {
        public static UiTreeModelListener get(TreeModelListener listener) {
            return (UiTreeModelListener)UiTreeModelListener.get(listener, UiTreeModelListener.class);
        }

        @Override
        public void treeNodesChanged(oracle.bpm.ui.event.TreeModelEvent e) {
            this.getDelegate().treeNodesChanged(this.mapEvent(e));
        }

        @Override
        public void treeNodesInserted(oracle.bpm.ui.event.TreeModelEvent e) {
            this.getDelegate().treeNodesInserted(this.mapEvent(e));
        }

        @Override
        public void treeNodesRemoved(oracle.bpm.ui.event.TreeModelEvent e) {
            this.getDelegate().treeNodesRemoved(this.mapEvent(e));
        }

        @Override
        public void treeStructureChanged(oracle.bpm.ui.event.TreeModelEvent e) {
            this.getDelegate().treeStructureChanged(this.mapEvent(e));
        }

        private TreeModelListener getDelegate() {
            return (TreeModelListener)this.getEventListener();
        }

        private TreeModelEvent mapEvent(oracle.bpm.ui.event.TreeModelEvent e) {
            return new TreeModelEvent((Object)this, e.getPath());
        }
    }

    public static class RevertSwingListener {
        private EventListener eventListener;
        private static Map<Class, WeakHashMap<EventListener, RevertSwingListener>> listeners = new WeakHashMap<Class, WeakHashMap<EventListener, RevertSwingListener>>();

        public void setEventListener(EventListener uiListener) {
            this.eventListener = uiListener;
        }

        public EventListener getEventListener() {
            return this.eventListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static RevertSwingListener get(EventListener listener, Class implClass) {
            assert (listener != null) : "Listener cannot be null";
            RevertSwingListener result = null;
            Map<Class, WeakHashMap<EventListener, RevertSwingListener>> map = listeners;
            synchronized (map) {
                WeakHashMap<EventListener, RevertSwingListener> listenersByClass = listeners.get(implClass);
                if (listenersByClass == null) {
                    listenersByClass = new WeakHashMap();
                    listeners.put(implClass, listenersByClass);
                }
                if ((result = listenersByClass.get(listener)) == null) {
                    result = RevertSwingListener.create(listener, implClass);
                }
                listenersByClass.put(listener, result);
            }
            return result;
        }

        private static RevertSwingListener create(EventListener listener, Class impl) {
            RevertSwingListener result = null;
            try {
                result = (RevertSwingListener)impl.newInstance();
                result.setEventListener(listener);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return result;
        }
    }
}

