/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.peer.AbstractButtonPeer;
import oracle.bpm.ui.peer.CompositeButtonPeer;
import oracle.bpm.ui.peer.ToolBarPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;

public class SwingToolBar
extends SwingContainer
implements ToolBarPeer {
    private ButtonGroup group;

    SwingToolBar(SwingComponent parent, ToolBar.Orientation orientation, ToolBar.Alignment align) {
        super(parent, new JToolBar(orientation == ToolBar.HORIZONTAL ? 0 : 1));
        this.getToolBar().putClientProperty("ToolBar.isRollover", Boolean.TRUE);
        this.getToolBar().setFloatable(false);
        this.getToolBar().setBorderPainted(false);
    }

    @Override
    public void add(UiComponent uiComponent) {
        this.getToolBar().add(uiComponent.asSwing());
    }

    public void add(AbstractButtonPeer peer, int width) {
        peer.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        AbstractButton btn = (AbstractButton)((SwingComponent)((Object)peer)).getComponent();
        this.getToolBar().add(btn);
    }

    public void add(CompositeButtonPeer peer) {
        this.add(peer, 0);
    }

    @Override
    public void addSeparator() {
        this.getToolBar().addSeparator();
        this.group = new ButtonGroup();
    }

    public ButtonGroup getCurrentGroup() {
        if (this.group == null) {
            this.group = new ButtonGroup();
        }
        return this.group;
    }

    JToolBar getToolBar() {
        return (JToolBar)this.getJComponent();
    }
}

