/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import oracle.bpm.ui.event.TreeModelEvent;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.treetable.TreeTableModel;

final class SwingTableModelAdapter
extends AbstractTableModel {
    private final JTree tree;
    private final TreeTableModel treeTableModel;
    static final long serialVersionUID = 6251461082786540433L;

    public SwingTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new MyTreeExpansionListener(this));
        treeTableModel.addTreeModelListener(new MyTreeModelListener(this));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0 || this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    private Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath == null ? null : treePath.getLastPathComponent();
    }

    private static final class MyTreeModelListener
    implements TreeModelListener {
        private final RunFireTableDataChaged fireTableDataChanged;

        public MyTreeModelListener(SwingTableModelAdapter adapter) {
            this.fireTableDataChanged = new RunFireTableDataChaged(adapter);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.fire();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.fire();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.fire();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.fire();
        }

        private void fire() {
            SwingUtilities.invokeLater(this.fireTableDataChanged);
        }

        private static final class RunFireTableDataChaged
        implements Runnable {
            private final SwingTableModelAdapter adapter;

            public RunFireTableDataChaged(SwingTableModelAdapter adapter) {
                this.adapter = adapter;
            }

            @Override
            public void run() {
                this.adapter.fireTableDataChanged();
            }
        }
    }

    private static final class MyTreeExpansionListener
    implements TreeExpansionListener {
        private final SwingTableModelAdapter adapter;

        public MyTreeExpansionListener(SwingTableModelAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.adapter.fireTableDataChanged();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.adapter.fireTableDataChanged();
        }
    }
}

