/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.peer.TablePeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.ExtendedTable;
import oracle.bpm.ui.peer.swing.SwingCellEditor;
import oracle.bpm.ui.peer.swing.SwingCellRenderer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.event.SwingListSelectionListener;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.ViewerSorter;
import oracle.bpm.ui.table.editors.BooleanCheckBoxCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;

public class SwingTable
extends SwingContainer
implements TablePeer {
    private HashMap<Class, SwingCellRenderer> classRendererMap;

    public SwingTable(SwingComponent parent, ListSelectionMode selectionMode) {
        this(parent, new ExtendedTable());
        this.getTable().setSelectionMode(selectionMode);
    }

    protected SwingTable(SwingComponent parent, Component component) {
        super(parent, new JScrollPane(component));
    }

    public static TableModelEvent get(javax.swing.table.TableModel model, oracle.bpm.ui.event.TableModelEvent e) {
        return new TableModelEvent(model, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType());
    }

    @Override
    public List<UiComponent> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void setAutoResizeMode(AutoResizeMode mode) {
        this.getTable().setAutoResizeMode(mode);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getTable().isCellEditable(row, column);
    }

    @Override
    public void scrollToRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        ExtendedTable table = this.getTable();
        Rectangle rect = table.getCellRect(row, 0, true);
        table.scrollRectToVisible(rect);
    }

    @Override
    public TableCellEditor getCellEditor() {
        javax.swing.table.TableCellEditor editor = this.getTable().getCellEditor();
        if (editor instanceof SwingCellEditor) {
            return (TableCellEditor)((SwingCellEditor)editor).getCellEditor();
        }
        return null;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        javax.swing.table.TableCellEditor editor = this.getTable().getCellEditor(row, column);
        if (editor instanceof SwingCellEditor) {
            return (TableCellEditor)((SwingCellEditor)editor).getCellEditor();
        }
        return null;
    }

    @Override
    public oracle.bpm.geom.Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        return AwtConverter.fromAwt(this.getTable().getCellRect(row, column, includeSpacing));
    }

    @Override
    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.getTable().setCellSelectionEnabled(cellSelectionEnabled);
    }

    @Override
    public Class getColumnClass(int column) {
        return this.getTable().getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return this.getTable().getColumnCount();
    }

    @Override
    public void setColumnHideAllowed(boolean columnHideAllowed) {
        this.getTable().setColumnHideAllowed(columnHideAllowed);
    }

    @Override
    public String getColumnName(int column) {
        return this.getTable().getColumnName(column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.getTable().isColumnVisible(column);
    }

    public void setDefaultColorProvider(Class columnClass, ColorProvider provider) {
        this.getSwingRenderer(columnClass).setColorProvider(provider);
    }

    public void setDefaultEditor(Class columnClass, TableCellEditor editor) {
        if (!(editor instanceof BooleanCheckBoxCellEditor)) {
            SwingCellEditor cellEditor = editor != null ? new SwingCellEditor(editor) : null;
            this.getTable().setDefaultEditor(columnClass, cellEditor);
        }
    }

    public TableCellEditor getDefaultEditor(Class columnClass) {
        javax.swing.table.TableCellEditor editor = this.getTable().getDefaultEditor(columnClass);
        if (editor instanceof SwingCellEditor) {
            return (TableCellEditor)((SwingCellEditor)editor).getCellEditor();
        }
        return null;
    }

    @Override
    public void setDefaultFontProvider(Class<?> columnClass, FontProvider provider) {
        this.getSwingRenderer(columnClass).setFontProvider(provider);
    }

    @Override
    public void setDefaultLabelProvider(Class<?> columnClass, LabelProvider provider) {
        if (!(provider instanceof BooleanCheckBoxLabelProvider)) {
            this.getSwingRenderer(columnClass).setLabelProvider(provider);
        }
    }

    @Override
    public boolean isEditing() {
        return this.getTable().isEditing();
    }

    @Override
    public int getEditingColumn() {
        return this.getTable().getEditingColumn();
    }

    @Override
    public int getEditingRow() {
        return this.getTable().getEditingRow();
    }

    @Override
    public void setHeaderVisible(boolean show) {
        this.getTable().setHeaderVisible(show);
    }

    @Override
    public boolean isHeaderVisible() {
        return this.getTable().getTableHeader() != null;
    }

    @Override
    public void setModel(TableModel model) {
        this.getTable().setModel(new SwingTableModel(model));
    }

    @Override
    public TableModel getModel() {
        javax.swing.table.TableModel model = this.getTable().getModel();
        return model instanceof SwingTableModel ? ((SwingTableModel)model).getTableModel() : null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return AwtConverter.fromAwt(this.getTable().getPreferredScrollableViewportSize());
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this.getTable().setRowHeight(rowHeight);
    }

    @Override
    public void setRelativeSizes(double[] sizes) {
        this.getTable().setRelativesSizes(sizes);
    }

    @Override
    public void setReorderingAllowed(boolean reorderingAllowed) {
        this.getTable().getTableHeader().setReorderingAllowed(reorderingAllowed);
    }

    @Override
    public boolean isReorderingAllowed() {
        return this.getTable().getTableHeader().getReorderingAllowed();
    }

    @Override
    public int getRowCount() {
        return this.getTable().getRowCount();
    }

    @Override
    public int getRowHeight() {
        return this.getTable().getRowHeight();
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.getTable().isRowSelected(row);
    }

    @Override
    public int getSelectedColumn() {
        return this.getTable().getSelectedColumn();
    }

    @Override
    public int getSelectedRow() {
        return this.getTable().getSelectedRow();
    }

    @Override
    public int getSelectedRowCount() {
        return this.getTable().getSelectedRowCount();
    }

    @Override
    public int[] getSelectedRows() {
        return this.getTable().getSelectedRows();
    }

    @Override
    public void setSelection(int index) {
        this.setSelectionInterval(index, index);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        this.getTable().getSelectionModel().setSelectionInterval(index0, index1);
    }

    @Override
    public void setShowGrid(boolean showGrid) {
        this.getTable().setShowGrid(showGrid);
    }

    @Override
    public void setShowHorizontalLines(boolean showHorizontalLines) {
        this.getTable().setShowHorizontalLines(showHorizontalLines);
    }

    @Override
    public void setShowVerticalLines(boolean showVerticalLines) {
        this.getTable().setShowVerticalLines(showVerticalLines);
    }

    @Override
    public void setSorter(ViewerSorter sorter) {
    }

    @Override
    public ViewerSorter getSorter() {
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.getTable().setValueAt(aValue, row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getTable().getValueAt(row, column);
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.getTable().addEditorListener(listener);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.getTable().getSelectionModel().addListSelectionListener(SwingListSelectionListener.get(listener));
    }

    @Override
    public void addRowSelectionInterval(int index0, int index1) {
        this.getTable().addRowSelectionInterval(index0, index1);
    }

    @Override
    public void clearSelection() {
        this.getTable().clearSelection();
    }

    @Override
    public int columnAtPoint(Point point) {
        return this.getTable().columnAtPoint(AwtConverter.toAwt(point));
    }

    @Override
    public void editCellAt(int row, int column) {
        this.getTable().editCellAt(row, column);
    }

    @Override
    public void freezeFirstColumn() {
        this.getTable().freezeFirstColumn();
    }

    @Override
    public void setPreferredRows(int preferredRows) {
        this.getTable().setPreferredRows(preferredRows);
    }

    @Override
    public void hideColumn(int column) {
        this.getTable().hideColumn(column);
    }

    @Override
    public void moveColumn(int column, int targetColumn) {
        this.getTable().moveColumn(column, targetColumn);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.getTable().removeEditorListener(listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getTable().getSelectionModel().removeListSelectionListener(SwingListSelectionListener.get(listener));
    }

    @Override
    public void removeRowSelectionInterval(int index0, int index1) {
        this.getTable().removeRowSelectionInterval(index0, index1);
    }

    @Override
    public int rowAtPoint(Point point) {
        return this.getTable().rowAtPoint(AwtConverter.toAwt(point));
    }

    @Override
    public void showColumn(int column) {
        this.getTable().showColumn(column);
    }

    @Override
    public void tableChanged(oracle.bpm.ui.event.TableModelEvent e) {
        this.getTable().tableChanged(SwingTable.get(this.getTable().getModel(), e));
    }

    @Override
    public JComponent getJComponent() {
        JScrollPane scrollPane = (JScrollPane)super.getJComponent();
        return (JComponent)scrollPane.getViewport().getView();
    }

    @Override
    public Component getInputTarget() {
        return this.getTable();
    }

    protected SwingCellRenderer getSwingRenderer(Class columnClass) {
        SwingCellRenderer renderer = this.getClassRenderer().get(columnClass);
        if (renderer == null) {
            renderer = new SwingCellRenderer();
            this.getClassRenderer().put(columnClass, renderer);
            this.getTable().setDefaultRenderer(columnClass, renderer);
        }
        return renderer;
    }

    private Map<Class, SwingCellRenderer> getClassRenderer() {
        if (this.classRendererMap == null) {
            this.classRendererMap = new HashMap();
        }
        return this.classRendererMap;
    }

    private ExtendedTable getTable() {
        return (ExtendedTable)this.getJComponent();
    }

    private static class SwingTableModel
    implements javax.swing.table.TableModel {
        private TableModel tableModel;

        SwingTableModel(TableModel tableModel) {
            this.tableModel = tableModel;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.getTableModel().isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getTableModel().getColumnClass(columnIndex);
        }

        @Override
        public int getColumnCount() {
            return this.getTableModel().getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.getTableModel().getColumnName(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.getTableModel().getRowCount();
        }

        public TableModel getTableModel() {
            return this.tableModel;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.getTableModel().setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.getTableModel().getValueAt(rowIndex, columnIndex);
        }

        @Override
        public void addTableModelListener(final javax.swing.event.TableModelListener l) {
            this.getTableModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(oracle.bpm.ui.event.TableModelEvent e) {
                    l.tableChanged(SwingTable.get(SwingTableModel.this, e));
                }
            });
        }

        @Override
        public void removeTableModelListener(javax.swing.event.TableModelListener l) {
        }
    }
}

