/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTabbedPane;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.peer.TabbedPanePeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingContainer;
import oracle.bpm.ui.peer.swing.event.SwingChangeListener;

public class SwingTabbedPane
extends SwingContainer
implements TabbedPanePeer {
    public SwingTabbedPane(SwingComponent parent) {
        super(parent, new ExtendedTabbedPane());
    }

    @Override
    public void setComponentAt(int index, UiComponent component) {
        this.getTabbedPane().setComponentAt(index, SwingTabbedPane.asSwing(component));
    }

    @Override
    public UiComponent getComponentAt(int index) {
        return UiComponent.get(this.getTabbedPane().getComponentAt(index));
    }

    @Override
    public List<UiComponent> getChildren() {
        List<UiComponent> result = Collections.emptyList();
        if (this.getComponentCount() > 0) {
            result = new ArrayList<UiComponent>();
            for (int i = 0; i < this.getTabCount(); ++i) {
                result.add(this.getComponentAt(i));
            }
        }
        return result;
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        this.getTabbedPane().setEnabledAt(index, enabled);
    }

    @Override
    public void setHideOnTab(boolean hideOnTab) {
    }

    @Override
    public void setIconAt(int index, Image icon) {
        this.getTabbedPane().setIconAt(index, SwingTabbedPane.asSwingIcon(icon));
    }

    @Override
    public void setBackgroundAt(int index, Color color) {
        this.getTabbedPane().setBackgroundAt(index, AwtConverter.toAwt(color));
    }

    @Override
    public void setForegroundAt(int index, Color color) {
        this.getTabbedPane().setForegroundAt(index, AwtConverter.toAwt(color));
    }

    @Override
    public void setSelectedComponent(UiComponent component) {
        this.getTabbedPane().setSelectedComponent(SwingTabbedPane.asSwing(component));
    }

    @Override
    public UiComponent getSelectedComponent() {
        return UiComponent.get(this.getTabbedPane().getSelectedComponent());
    }

    @Override
    public void setSelectedIndex(int index) {
        this.getTabbedPane().setSelectedIndex(index);
    }

    @Override
    public int getSelectedIndex() {
        return this.getTabbedPane().getSelectedIndex();
    }

    @Override
    public int getTabCount() {
        return this.getTabbedPane().getTabCount();
    }

    @Override
    public void setTabPlacement(int placement) {
        this.getTabbedPane().setTabPlacement(placement);
    }

    @Override
    public void setTitleAt(int index, String title) {
        this.getTabbedPane().setTitleAt(index, title);
    }

    @Override
    public String getTitleAt(int index) {
        return this.getTabbedPane().getTitleAt(index);
    }

    @Override
    public void setToolTipTextAt(int index, String tooltip) {
        this.getTabbedPane().setToolTipTextAt(index, tooltip);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.getTabbedPane().addChangeListener(SwingChangeListener.get(listener));
    }

    @Override
    public void addTab(String title, UiComponent component) {
        this.getTabbedPane().addTab(title, SwingTabbedPane.asSwing(component));
    }

    @Override
    public void addTab(String title, Image icon, UiComponent component) {
        this.getTabbedPane().addTab(title, SwingTabbedPane.asSwingIcon(icon), SwingTabbedPane.asSwing(component));
    }

    @Override
    public void addTab(String title, Image icon, UiComponent component, String tooltip) {
        this.getTabbedPane().addTab(title, SwingTabbedPane.asSwingIcon(icon), SwingTabbedPane.asSwing(component), tooltip);
    }

    @Override
    public int indexOfComponent(UiComponent component) {
        return this.getTabbedPane().indexOfComponent(SwingTabbedPane.asSwing(component));
    }

    @Override
    public int indexOfTab(String title) {
        return this.getTabbedPane().indexOfTab(title);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.getTabbedPane().removeChangeListener(SwingChangeListener.get(listener));
    }

    private JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getJComponent();
    }

    private static class ExtendedTabbedPane
    extends JTabbedPane {
        ExtendedTabbedPane() {
            this.init();
        }

        private void init() {
            this.setTabLayoutPolicy(1);
        }
    }
}

