/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import oracle.bpm.ui.RegexpFormatter;
import oracle.bpm.ui.peer.RegexpTextFieldPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;
import oracle.bpm.ui.peer.swing.SwingTextField;

public class SwingRegexpTextField
extends SwingTextField
implements RegexpTextFieldPeer {
    SwingRegexpTextField(SwingComponent parent) {
        super(parent, new ExtendedFormattedTextField());
    }

    SwingRegexpTextField(SwingComponent parent, boolean allowsInvalid) {
        super(parent, new ExtendedFormattedTextField(allowsInvalid));
    }

    @Override
    public void setPattern(String pattern) {
        this.getTextField().setPattern(pattern);
    }

    @Override
    protected ExtendedFormattedTextField getTextField() {
        return (ExtendedFormattedTextField)this.getJComponent();
    }

    private static class ExtendedFormattedTextField
    extends JFormattedTextField {
        ExtendedFormattedTextField() {
            this(true);
        }

        ExtendedFormattedTextField(boolean allowsInvalid) {
            RegexpFormatter formatter = new RegexpFormatter();
            formatter.setAllowsInvalid(allowsInvalid);
            formatter.setOverwriteMode(false);
            formatter.setCommitsOnValidEdit(true);
            this.setFocusLostBehavior(0);
            this.setFormatterFactory(new DefaultFormatterFactory(formatter));
            this.setInputVerifier(new FormattedTextFieldVerifier());
        }

        public void setPattern(String pattern) {
            RegexpFormatter formatter = (RegexpFormatter)this.getFormatter();
            formatter.setPattern(pattern);
        }

        public boolean isValidValue() {
            return this.getInputVerifier().verify(this);
        }

        private static class FormattedTextFieldVerifier
        extends InputVerifier {
            private FormattedTextFieldVerifier() {
            }

            @Override
            public boolean shouldYieldFocus(JComponent input) {
                return this.verify(input);
            }

            @Override
            public boolean verify(JComponent input) {
                JFormattedTextField ftf;
                JFormattedTextField.AbstractFormatter formatter;
                if (input instanceof JFormattedTextField && (formatter = (ftf = (JFormattedTextField)input).getFormatter()) != null) {
                    String text = ftf.getText();
                    try {
                        formatter.stringToValue(text);
                        return true;
                    }
                    catch (ParseException pe) {
                        return false;
                    }
                }
                return true;
            }
        }
    }
}

