/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.peer.ProgressMonitorPeer;
import oracle.bpm.ui.peer.swing.SwingComponent;

public class SwingProgressMonitor
extends SwingComponent
implements ProgressMonitorPeer {
    private JProgressBar progressBar;
    private JLabel subTaskLabel;
    private JLabel taskLabel;

    public SwingProgressMonitor(SwingComponent parent) {
        super(parent, new JPanel());
        this.createComponents();
        this.layoutComponents();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    @Override
    public void setMessage(String message) {
        this.progressBar.setString(message);
    }

    @Override
    public void setSubTask(String subTask) {
        this.subTaskLabel.setText(subTask);
    }

    @Override
    public void setTask(String task) {
        this.taskLabel.setText(task);
    }

    @Override
    public void setValue(int percentage) {
        if (this.progressBar.isIndeterminate() && percentage == 100) {
            this.progressBar.setIndeterminate(false);
        }
        this.progressBar.setString(null);
        this.progressBar.setValue(percentage);
    }

    @Override
    public int getValue() {
        return this.progressBar.getValue();
    }

    private void createComponents() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.taskLabel = new JLabel();
        this.subTaskLabel = new JLabel();
    }

    private void layoutComponents() {
        String columns = "10dlu, 100dlu, 8dlu, 50dlu, 50dlu, 10dlu";
        String rows = "10dlu, 15dlu, 4dlu, 15dlu, 10dlu";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        JComponent jComponent = this.getJComponent();
        jComponent.add((Component)this.taskLabel, cc.xy(2, 2));
        jComponent.add((Component)this.subTaskLabel, cc.xy(4, 2));
        jComponent.add((Component)this.progressBar, cc.xywh(2, 4, 4, 1));
    }
}

