/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import oracle.bpm.print.PrintUtils;
import oracle.bpm.print.Printable;
import oracle.bpm.ui.peer.PrinterPeer;

public class SwingPrinter
implements PrinterPeer {
    private PageFormat pageFormat;
    private PrinterJob printerJob = PrinterJob.getPrinterJob();

    @Override
    public boolean printDialog() {
        return this.printerJob.printDialog();
    }

    @Override
    public void setCopies(int copies) {
        this.printerJob.setCopies(copies);
    }

    @Override
    public oracle.bpm.print.PageFormat pageDialog(oracle.bpm.print.PageFormat page) {
        return new oracle.bpm.print.PageFormat(this.printerJob.pageDialog(page.asSwing()));
    }

    @Override
    public oracle.bpm.print.PageFormat defaultPage() {
        return new oracle.bpm.print.PageFormat(this.printerJob.defaultPage());
    }

    @Override
    public oracle.bpm.print.PageFormat validatePage(oracle.bpm.print.PageFormat pageFormat) {
        PageFormat pf = this.printerJob.validatePage(pageFormat.asSwing());
        return new oracle.bpm.print.PageFormat(pf);
    }

    @Override
    public oracle.bpm.print.PageFormat print(final Printable printable) {
        if (this.pageFormat == null && this.printerJob != null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        Thread printThread = new Thread(){

            @Override
            public void run() {
                if (SwingPrinter.this.printDialog()) {
                    PageFormat format = SwingPrinter.this.pageFormat;
                    SwingPrinter.this.printerJob.setPrintable(PrintUtils.asAwtPrintable(printable), format);
                    SwingPrinter.this.printerJob.validatePage(format);
                    try {
                        SwingPrinter.this.printerJob.print();
                    }
                    catch (PrinterException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        printThread.start();
        return new oracle.bpm.print.PageFormat(this.pageFormat);
    }

    @Override
    public void setPageFormat(oracle.bpm.print.PageFormat pageFormat) {
        this.pageFormat = pageFormat.asSwing();
    }

    @Override
    public Object getClientProperty(String key) {
        return null;
    }

    @Override
    public void putClientProperty(String key, Object value) {
    }

    @Override
    public boolean isDisposed() {
        return this.printerJob == null;
    }

    @Override
    public void dispose() {
        this.printerJob = null;
    }
}

